/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.preverification;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;

public class StackMapTableAttribute
extends Attribute {
    public int u2stackMapFramesCount;
    public StackMapFrame[] stackMapFrames;

    public StackMapTableAttribute() {
    }

    public StackMapTableAttribute(StackMapFrame[] stackMapFrames) {
        this(stackMapFrames.length, stackMapFrames);
    }

    public StackMapTableAttribute(int stackMapFramesCount, StackMapFrame[] stackMapFrames) {
        this.u2stackMapFramesCount = stackMapFramesCount;
        this.stackMapFrames = stackMapFrames;
    }

    @Override
    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, AttributeVisitor attributeVisitor) {
        attributeVisitor.visitStackMapTableAttribute(clazz, method, codeAttribute, this);
    }

    public void stackMapFramesAccept(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapFrameVisitor stackMapFrameVisitor) {
        int offset = 0;
        for (int index = 0; index < this.u2stackMapFramesCount; ++index) {
            StackMapFrame stackMapFrame = this.stackMapFrames[index];
            stackMapFrame.accept(clazz, method, codeAttribute, offset += stackMapFrame.getOffsetDelta() + (index == 0 ? 0 : 1), stackMapFrameVisitor);
        }
    }
}

