/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import docking.DockingUtils;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VisualGraphMousePlugin;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class VisualGraphScreenPositioningPlugin<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractGraphMousePlugin
implements MouseWheelListener,
VisualGraphMousePlugin<V, E> {
    public VisualGraphScreenPositioningPlugin() {
        super(0);
    }

    public boolean checkModifiers(MouseEvent e) {
        return e.getModifiersEx() == this.modifiers;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean controlKeyDown;
        int eventModifiers = e.getModifiersEx();
        boolean bl = controlKeyDown = (eventModifiers & DockingUtils.CONTROL_KEY_MODIFIER_MASK) != 0;
        if (!controlKeyDown) {
            return;
        }
        int wheelRotation = -e.getWheelRotation();
        int offset = wheelRotation * 10;
        Point newPoint = new Point(0, offset);
        if (e.isAltDown()) {
            newPoint.setLocation(offset, 0);
        }
        VisualGraphViewUpdater updater = this.getViewUpdater(e);
        updater.moveViewerLocationWithoutAnimation(newPoint);
    }
}

