/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.stream;

import db.buffers.BlockStream;
import ghidra.server.stream.RemoteBlockStreamHandle;
import ghidra.util.StringUtilities;
import ghidra.util.timer.GTimer;
import ghidra.util.timer.GTimerMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockStreamServer
extends Thread {
    private static Logger log = LogManager.getLogger(BlockStreamServer.class);
    private static BlockStreamServer server;
    private static int REQUEST_HEADER_TIMEOUT_MS;
    private static int MAX_AGE_MS;
    private static int CLEANUP_PERIOD;
    private Map<Long, BlockStreamRegistration> blockStreamMap = new HashMap<Long, BlockStreamRegistration>();
    private long nextStreamID = System.currentTimeMillis();
    private String hostname;
    private volatile boolean running;
    private ServerSocket serverSocket;
    private GTimerMonitor cleanupTimerMonitor;

    public static synchronized BlockStreamServer getBlockStreamServer() {
        if (server == null) {
            server = new BlockStreamServer();
        }
        return server;
    }

    private BlockStreamServer() {
        super("BlockStreamServer");
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public int getServerPort() {
        return this.serverSocket != null ? this.serverSocket.getLocalPort() : -1;
    }

    public String getServerHostname() {
        return this.hostname;
    }

    public synchronized long getNextStreamID() {
        return this.nextStreamID++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerBlockStream(RemoteBlockStreamHandle<?> streamHandle, BlockStream blockStream) {
        Map<Long, BlockStreamRegistration> map = this.blockStreamMap;
        synchronized (map) {
            if (!this.running) {
                return false;
            }
            if (streamHandle == null || blockStream == null) {
                throw new IllegalArgumentException("null argument not permitted");
            }
            long streamID = streamHandle.getStreamID();
            if (!streamHandle.isPending() || this.blockStreamMap.containsKey(streamID)) {
                throw new IllegalArgumentException("stream handle previously registered/used");
            }
            this.blockStreamMap.put(streamID, new BlockStreamRegistration(this, streamHandle, blockStream));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupStaleRequests(boolean cleanupAll) {
        Map<Long, BlockStreamRegistration> map = this.blockStreamMap;
        synchronized (map) {
            ArrayList<Long> staleStreamIds = new ArrayList<Long>();
            for (BlockStreamRegistration registration : this.blockStreamMap.values()) {
                long age = System.currentTimeMillis() - registration.timestamp;
                if (age <= (long)MAX_AGE_MS) continue;
                staleStreamIds.add(registration.streamHandle.getStreamID());
                try {
                    registration.blockStream.close();
                }
                catch (IOException iOException) {}
            }
            Iterator<BlockStreamRegistration> iterator = staleStreamIds.iterator();
            while (iterator.hasNext()) {
                long id = (Long)((Object)iterator.next());
                this.blockStreamMap.remove(id);
            }
        }
    }

    public synchronized void startServer(ServerSocket s, String host) throws IOException {
        if (this.running) {
            throw new IOException("server already started");
        }
        if (s == null || s.isClosed() || StringUtilities.isAllBlank((CharSequence[])new CharSequence[]{host})) {
            throw new IllegalArgumentException("invalid startServer parameters");
        }
        this.serverSocket = s;
        this.hostname = host;
        this.running = true;
        log.info("Starting Block Stream Server...");
        this.cleanupTimerMonitor = GTimer.scheduleRepeatingRunnable((long)CLEANUP_PERIOD, (long)CLEANUP_PERIOD, () -> this.cleanupStaleRequests(false));
        this.start();
    }

    public synchronized void stopServer() {
        if (this.running) {
            this.running = false;
            this.cleanupTimerMonitor.cancel();
            this.cleanupStaleRequests(true);
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.info("Shutdown Block Stream Server completed");
            this.interrupt();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                BlockStreamHandler handler = new BlockStreamHandler(socket);
                handler.start();
            }
            catch (InterruptedIOException handler) {
            }
            catch (IOException e) {
                if (!this.running) continue;
                log.error("block stream connection failure", (Throwable)e);
            }
            catch (Throwable t) {
                log.error("severe block stream server failure: ", t);
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        REQUEST_HEADER_TIMEOUT_MS = 10000;
        MAX_AGE_MS = 30000;
        CLEANUP_PERIOD = 30000;
    }

    private class BlockStreamRegistration {
        final RemoteBlockStreamHandle<?> streamHandle;
        final BlockStream blockStream;
        final long timestamp = System.currentTimeMillis();
        HandlerConnectionState state = HandlerConnectionState.INIT;

        BlockStreamRegistration(BlockStreamServer blockStreamServer, RemoteBlockStreamHandle<?> streamHandle, BlockStream blockStream) {
            this.streamHandle = streamHandle;
            this.blockStream = blockStream;
        }
    }

    private class BlockStreamHandler
    extends Thread {
        private Socket socket;
        private BlockStreamRegistration registration;

        BlockStreamHandler(Socket socket) {
            super("BlockStreamHandler-" + String.valueOf(socket.getInetAddress()) + "-" + socket.getPort());
            this.socket = socket;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RemoteBlockStreamHandle.StreamRequest readStreamRequest() throws IOException {
            byte[] headerBytes;
            GTimerMonitor requestReadTimer = GTimer.scheduleRunnable((long)REQUEST_HEADER_TIMEOUT_MS, () -> {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            try {
                int cnt;
                InputStream in = this.socket.getInputStream();
                headerBytes = new byte[RemoteBlockStreamHandle.HEADER_LENGTH];
                for (int index = 0; index < headerBytes.length; index += cnt) {
                    cnt = in.read(headerBytes, index, headerBytes.length - index);
                    if (cnt >= 0) continue;
                    throw new SocketException("connection closed by client");
                }
            }
            finally {
                requestReadTimer.cancel();
            }
            return RemoteBlockStreamHandle.parseStreamRequestHeader(headerBytes);
        }
    }

    private static enum HandlerConnectionState {
        INIT,
        READ_HEADER_TIMEOUT,
        CONNECTED,
        CLOSED;

    }
}

