/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.ResponseOptionalValues;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class QueryOptionalValues
extends BSimQuery<ResponseOptionalValues> {
    public ResponseOptionalValues optionalresponse = null;
    public Object[] keys = null;
    public String tableName = null;
    public int keyType = -1;
    public int valueType = -1;

    public QueryOptionalValues() {
        super("queryoptionalvalues");
    }

    @Override
    public void buildResponseTemplate() {
        if (this.response == null) {
            this.optionalresponse = new ResponseOptionalValues();
            this.response = this.optionalresponse;
        }
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        fwrite.append("<tablename>");
        SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.tableName);
        fwrite.append("</tablename>\n");
        fwrite.append("<keytype>");
        fwrite.append(Integer.toString(this.keyType));
        fwrite.append("</keytype>\n");
        fwrite.append("<valuetype>");
        fwrite.append(Integer.toString(this.valueType));
        fwrite.append("</valuetype>\n");
        for (Object key : this.keys) {
            fwrite.append("<key>");
            SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)key.toString());
            fwrite.append("</key>\n");
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        this.keys = null;
        ArrayList<String> resultKeys = new ArrayList<String>();
        parser.start(new String[]{this.name});
        parser.start(new String[]{"tablename"});
        this.tableName = parser.end().getText();
        parser.start(new String[]{"keytype"});
        this.keyType = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"valuetype"});
        this.valueType = SpecXmlUtils.decodeInt((String)parser.end().getText());
        while (parser.peek().isStart()) {
            parser.start(new String[0]);
            String key = parser.end().getText();
            resultKeys.add(key);
        }
        parser.end();
        if (!resultKeys.isEmpty()) {
            this.keys = new Object[resultKeys.size()];
            resultKeys.toArray(this.keys);
        }
    }
}

