/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph;

import ghidra.util.graph.AbstractDependencyGraph;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.set.ListOrderedSet;

public class DeterministicDependencyGraph<T>
extends AbstractDependencyGraph<T> {
    public DeterministicDependencyGraph() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeterministicDependencyGraph(DeterministicDependencyGraph<T> other) {
        DeterministicDependencyGraph<T> deterministicDependencyGraph = other;
        synchronized (deterministicDependencyGraph) {
            for (AbstractDependencyGraph.DependencyNode node : other.nodeMap.values()) {
                this.addValue(node.getValue());
                if (node.getSetOfNodesThatDependOnMe() == null) continue;
                for (AbstractDependencyGraph.DependencyNode child : node.getSetOfNodesThatDependOnMe()) {
                    this.addDependency(child.getValue(), node.getValue());
                }
            }
        }
    }

    @Override
    public DeterministicDependencyGraph<T> copy() {
        return new DeterministicDependencyGraph<T>(this);
    }

    @Override
    protected Map<T, AbstractDependencyGraph.DependencyNode> createNodeMap() {
        return new TreeMap();
    }

    @Override
    protected Set<T> createNodeSet() {
        return new ListOrderedSet();
    }

    @Override
    protected Set<AbstractDependencyGraph.DependencyNode> createDependencyNodeSet() {
        return new ListOrderedSet();
    }

    @Override
    public synchronized Set<T> getNodeMapValues() {
        return ListOrderedSet.listOrderedSet(this.nodeMap.keySet());
    }
}

