/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.logviewer.ui;

import docking.EmptyBorderToggleButton;
import docking.widgets.EmptyBorderButton;
import generic.theme.GIcon;
import ghidra.framework.main.logviewer.event.FVEvent;
import ghidra.framework.main.logviewer.event.FVEventListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToolBar;

public class FVToolBar
extends JToolBar {
    private EmptyBorderToggleButton scrollLockButton;
    private EmptyBorderButton fileOpenButton;
    private FVEventListener eventListener;

    public FVToolBar(FVEventListener eventListener) {
        this.eventListener = eventListener;
        this.createScrollLockTool();
        this.createFileOpenTool();
    }

    public boolean isScrollLockOn() {
        return this.scrollLockButton.isSelected();
    }

    public void setScrollLockOn(boolean lock) {
        this.scrollLockButton.setSelected(lock);
    }

    private void createFileOpenTool() {
        FileOpenAction openAction = new FileOpenAction();
        this.fileOpenButton = new EmptyBorderButton();
        this.fileOpenButton.setAction((Action)openAction);
        this.fileOpenButton.setText("Opens the log file folder");
        this.fileOpenButton.setHideActionText(true);
        this.add((Component)this.fileOpenButton);
    }

    private void createScrollLockTool() {
        ScrollLockAction lockAction = new ScrollLockAction();
        this.scrollLockButton = new EmptyBorderToggleButton();
        this.scrollLockButton.setAction((Action)lockAction);
        this.scrollLockButton.setText("Scroll Lock");
        this.scrollLockButton.setHideActionText(true);
        this.add((Component)this.scrollLockButton);
    }

    private class FileOpenAction
    extends AbstractAction {
        public FileOpenAction() {
            super("FVFileOpenAction", (Icon)new GIcon("icon.logviewer.toolbar.file.open"));
            this.putValue("ShortDescription", "Opens the log file folder");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FVEvent openEvt = new FVEvent(FVEvent.EventType.OPEN_FILE_LOCATION, null);
            FVToolBar.this.eventListener.send(openEvt);
        }
    }

    private class ScrollLockAction
    extends AbstractAction {
        public ScrollLockAction() {
            super("FVScrollLockAction", (Icon)new GIcon("icon.logviewer.toolbar.scroll.lock"));
            this.putValue("ShortDescription", "Scroll Lock");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FVEvent tailEvt = FVToolBar.this.scrollLockButton.isSelected() ? new FVEvent(FVEvent.EventType.SCROLL_LOCK_ON, null) : new FVEvent(FVEvent.EventType.SCROLL_LOCK_OFF, null);
            FVToolBar.this.eventListener.send(tailEvt);
        }
    }
}

