/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

public class Lock {
    private Thread owner;
    private int lockAquireCount = 0;
    private int waiterCount = 0;
    private String name;

    public Lock(String name) {
        this.name = name;
    }

    public synchronized void acquire() {
        Thread currThread = Thread.currentThread();
        while (true) {
            if (this.owner == null) {
                this.lockAquireCount = 1;
                this.owner = currThread;
                return;
            }
            if (this.owner == currThread) {
                ++this.lockAquireCount;
                return;
            }
            try {
                ++this.waiterCount;
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
            continue;
            finally {
                --this.waiterCount;
                continue;
            }
            break;
        }
    }

    public synchronized void release() {
        Thread currThread = Thread.currentThread();
        if (this.lockAquireCount > 0 && this.owner == currThread) {
            if (--this.lockAquireCount == 0) {
                this.owner = null;
                if (this.waiterCount != 0) {
                    this.notify();
                }
            }
        } else {
            throw new IllegalStateException("Attempted to release an unowned lock: " + this.name);
        }
    }

    public Thread getOwner() {
        return this.owner;
    }
}

