/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.format.pef.PefDebug;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;

public class PefDebugAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "PEF Debug";
    private static final String DESCRIPTION = "Locates and applies PEF debug information.";

    public PefDebugAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.FUNCTION_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(new AnalysisPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.priority() * 2));
    }

    @Override
    public boolean canAnalyze(Program program) {
        return "Preferred Executable Format (PEF)".equals(program.getExecutableFormat());
    }

    @Override
    public boolean added(Program program, AddressSetView functionSet, TaskMonitor monitor, MessageLog log) {
        Listing listing = program.getListing();
        FunctionIterator functions = listing.getFunctions(functionSet, true);
        while (functions.hasNext() && !monitor.isCancelled()) {
            Function function = (Function)functions.next();
            Address address = function.getBody().getMaxAddress().add(1L);
            if (!this.isEnoughSpaceForDebugSymbol(program, address)) continue;
            try {
                this.applyStructure(program, address);
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
        }
        return true;
    }

    private void applyStructure(Program program, Address address) throws MemoryAccessException, AddressOutOfBoundsException, CodeUnitInsertionException, DuplicateNameException, InvalidInputException, CircularDependencyException {
        Listing listing = program.getListing();
        Memory memory = program.getMemory();
        PefDebug debug = new PefDebug(memory, address);
        if (!debug.isValid()) {
            return;
        }
        DataType debugDataType = debug.toDataType();
        DataUtilities.createData((Program)program, (Address)address, (DataType)debugDataType, (int)debugDataType.getLength(), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA);
        Address functionAddress = address.subtract((long)debug.getDistance());
        Function function = listing.getFunctionAt(functionAddress);
        if (function != null) {
            function.setParentNamespace(this.getNamespace(program));
            function.setName(debug.getName(), SourceType.IMPORTED);
        } else {
            Msg.debug((Object)this, (Object)"no function");
        }
    }

    private boolean isEnoughSpaceForDebugSymbol(Program program, Address startAddress) {
        Address endAddress = startAddress.add(18L);
        AddressSet addressSet = new AddressSet(startAddress, endAddress);
        InstructionIterator instructions = program.getListing().getInstructions((AddressSetView)addressSet, true);
        return !instructions.hasNext();
    }

    private Namespace getNamespace(Program program) {
        Namespace namespace = program.getSymbolTable().getNamespace(".debug", null);
        if (namespace != null) {
            return namespace;
        }
        try {
            return program.getSymbolTable().createNameSpace(null, ".debug", SourceType.IMPORTED);
        }
        catch (Exception e) {
            return null;
        }
    }
}

