/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.macro;

import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeDef;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFForm;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum DWARFMacroOpcode {
    MACRO_UNIT_TERMINATOR(0, "unknown", new DWARFForm[0]),
    DW_MACRO_define(1, "#define", DWARFForm.DW_FORM_udata, DWARFForm.DW_FORM_string),
    DW_MACRO_undef(2, "#undef", DWARFForm.DW_FORM_udata, DWARFForm.DW_FORM_string),
    DW_MACRO_start_file(3, "startfile", DWARFForm.DW_FORM_udata, DWARFForm.DW_FORM_udata),
    DW_MACRO_end_file(4, "endfile", new DWARFForm[0]),
    DW_MACRO_define_strp(5, "#define", DWARFForm.DW_FORM_udata, DWARFForm.DW_FORM_strp),
    DW_MACRO_undef_strp(6, "#undef", DWARFForm.DW_FORM_udata, DWARFForm.DW_FORM_strp),
    DW_MACRO_import(7, "#include", DWARFForm.DW_FORM_sec_offset),
    DW_MACRO_define_sup(8, "#define", DWARFForm.DW_FORM_udata, DWARFForm.DW_FORM_strp_sup),
    DW_MACRO_undef_sup(9, "#undef", DWARFForm.DW_FORM_udata, DWARFForm.DW_FORM_strp_sup),
    DW_MACRO_import_sup(10, "#include", DWARFForm.DW_FORM_sec_offset),
    DW_MACRO_define_strx(11, "#define", DWARFForm.DW_FORM_udata, DWARFForm.DW_FORM_strx),
    DW_MACRO_undef_strx(12, "#undef", DWARFForm.DW_FORM_udata, DWARFForm.DW_FORM_strx);

    private final int rawOpcode;
    private final String description;
    private final DWARFForm[] operandForms;
    private static DWARFMacroOpcode[] lookupValues;
    public static final Map<Integer, List<DWARFForm>> defaultOpcodeOperandMap;

    private DWARFMacroOpcode(int rawOpcode, String description, DWARFForm ... operandForms) {
        this.rawOpcode = rawOpcode;
        this.description = description;
        this.operandForms = operandForms;
    }

    public int getRawOpcode() {
        return this.rawOpcode;
    }

    public String getDescription() {
        return this.description;
    }

    public DWARFForm[] getOperandForms() {
        return this.operandForms;
    }

    public static DWARFMacroOpcode of(int opcodeVal) {
        for (DWARFMacroOpcode opcode : lookupValues) {
            if (opcode.rawOpcode != opcodeVal) continue;
            return opcode;
        }
        return null;
    }

    private static Map<Integer, List<DWARFForm>> getDefaultOpcodeOperandMap() {
        HashMap<Integer, List<DWARFForm>> results = new HashMap<Integer, List<DWARFForm>>();
        for (DWARFMacroOpcode opcode : DWARFMacroOpcode.values()) {
            results.put(opcode.getRawOpcode(), List.of(opcode.getOperandForms()));
        }
        return Collections.unmodifiableMap(results);
    }

    static {
        lookupValues = DWARFMacroOpcode.values();
        defaultOpcodeOperandMap = DWARFMacroOpcode.getDefaultOpcodeOperandMap();
    }

    public static class Def
    extends DWARFAttributeDef<DWARFMacroOpcode> {
        public Def(DWARFMacroOpcode opcode, int rawOpcode, DWARFForm form) {
            super(opcode, rawOpcode, form, -1L);
        }
    }
}

