/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.util;

import ghidra.app.util.viewer.util.AddressBasedOpenCloseManager;
import ghidra.app.util.viewer.util.DataOpenCloseManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;

public class ProgramOpenCloseManager {
    private DataOpenCloseManager dataOpenCloseManager = new DataOpenCloseManager();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private AddressBasedOpenCloseManager variablesOpenCloseManager = new AddressBasedOpenCloseManager();

    public void setFunctionVariablesOpen(Address functionAddress, boolean open) {
        if (open) {
            this.variablesOpenCloseManager.open(functionAddress);
        } else {
            this.variablesOpenCloseManager.close(functionAddress);
        }
        this.notifyListeners();
    }

    public boolean isFunctionVariablesOpen(Address functionAddress) {
        return this.variablesOpenCloseManager.isOpen(functionAddress);
    }

    public void setAllFunctionVariablesOpen(boolean open) {
        if (open) {
            this.variablesOpenCloseManager.openAll();
        } else {
            this.variablesOpenCloseManager.closeAll();
        }
        this.notifyListeners();
    }

    public boolean isAllFunctionVariablesOpen() {
        return this.variablesOpenCloseManager.isOpenByDefault();
    }

    public void openData(Data data) {
        this.dataOpenCloseManager.openData(data);
        this.notifyListeners();
    }

    public void closeData(Data data) {
        this.dataOpenCloseManager.closeData(data);
        this.notifyListeners();
    }

    public boolean isDataOpen(Address address) {
        return this.dataOpenCloseManager.isDataOpen(address, null);
    }

    public boolean isDataOpen(Data data) {
        return this.dataOpenCloseManager.isDataOpen(data);
    }

    public int getOpenDataIndex(Data data) {
        return this.dataOpenCloseManager.getOpenDataIndex(data.getMinAddress(), data.getComponentPath());
    }

    public void toggleDataOpen(Data data) {
        this.dataOpenCloseManager.toggleOpen(data);
        this.notifyListeners();
    }

    public void openAllData(Program program, AddressSetView addresses, TaskMonitor monitor) {
        this.dataOpenCloseManager.openAllData(program, addresses, monitor);
        this.notifyListeners();
    }

    public void closeAllData(Program program, AddressSetView addresses, TaskMonitor monitor) {
        this.dataOpenCloseManager.closeAllData(program, addresses, monitor);
        this.notifyListeners();
    }

    public void openDataRecursively(Data data, TaskMonitor monitor) {
        this.dataOpenCloseManager.toggleDataRecursively(data, true, monitor);
        this.notifyListeners();
    }

    public void closeDataRecursively(Data data, TaskMonitor monitor) {
        this.dataOpenCloseManager.toggleDataRecursively(data, false, monitor);
        this.notifyListeners();
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void notifyListeners() {
        for (ChangeListener l : this.listeners) {
            l.stateChanged(null);
        }
    }
}

