/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.ScreenFinder;
import net.sourceforge.swing.SwingUtils;

public class CacheAppViewer
extends JDialog {
    private boolean initialized = false;
    private static final String dialogTitle = Translator.R("CVCPDialogTitle");
    private final DeploymentConfiguration config;

    public CacheAppViewer(DeploymentConfiguration config) {
        super((Frame)null, dialogTitle, true);
        this.setName("CacheViewer");
        SwingUtils.info(this);
        this.config = config;
        if (config == null) {
            throw new IllegalArgumentException("config: " + config);
        }
        this.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        this.create();
    }

    private void create() {
        Container parentPane = this.getContentPane();
        JPanel mainPane = new JPanel();
        parentPane.setLayout(new BorderLayout());
        mainPane.setLayout(new GridLayout(2, 1));
        parentPane.add(mainPane);
        JTextArea info = new JTextArea();
        info.setEditable(false);
        final JTabbedPane idTabs = new JTabbedPane();
        final JPanel jnlpPaths = new JPanel(new BorderLayout());
        jnlpPaths.setName("jnlp-path");
        final JPanel domains = new JPanel(new BorderLayout());
        domains.setName("domain");
        idTabs.add(jnlpPaths);
        idTabs.add(domains);
        JButton delete = new JButton(Translator.R("TIFPDeleteFiles"));
        DummyCacheIdListModel jnlpPathsIds = new DummyCacheIdListModel(CacheUtil.getCacheIds(".*", true, false));
        DummyCacheIdListModel domainIds = new DummyCacheIdListModel(CacheUtil.getCacheIds(".*", false, true));
        final JList<CacheUtil.CacheId> appsByJnlpPath = new JList<CacheUtil.CacheId>();
        final JList<CacheUtil.CacheId> appsByDomain = new JList<CacheUtil.CacheId>();
        appsByJnlpPath.setSelectionMode(0);
        appsByDomain.setSelectionMode(0);
        delete.setEnabled(false);
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final Dimension d = CacheAppViewer.this.getSize();
                SwingUtils.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (idTabs.getSelectedComponent() == jnlpPaths) {
                            CacheUtil.clearCache(((CacheUtil.CacheId)appsByJnlpPath.getSelectedValue()).getId(), true, false);
                        }
                        if (idTabs.getSelectedComponent() == domains) {
                            CacheUtil.clearCache(((CacheUtil.CacheId)appsByDomain.getSelectedValue()).getId(), false, true);
                        }
                        CacheAppViewer.this.getContentPane().removeAll();
                        CacheAppViewer.this.pack();
                        CacheAppViewer.this.create();
                        CacheAppViewer.this.setSize(d);
                    }
                });
            }
        });
        appsByJnlpPath.setModel(jnlpPathsIds);
        appsByDomain.setModel(domainIds);
        appsByJnlpPath.addListSelectionListener(new DummyListSelectionListenerWithModel(info, appsByJnlpPath, delete));
        appsByDomain.addListSelectionListener(new DummyListSelectionListenerWithModel(info, appsByDomain, delete));
        jnlpPaths.add(mainPane.add(new JScrollPane(appsByJnlpPath)));
        domains.add(mainPane.add(new JScrollPane(appsByDomain)));
        mainPane.add(idTabs);
        idTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                appsByDomain.clearSelection();
                appsByJnlpPath.clearSelection();
            }
        });
        mainPane.add(new JScrollPane(info));
        parentPane.add((Component)delete, "South");
        this.pack();
    }

    public void centerDialog() {
        ScreenFinder.centerWindowsToCurrentScreen(this);
    }

    private static class DummyCacheIdListModel
    implements ListModel<CacheUtil.CacheId> {
        List<CacheUtil.CacheId> content;

        public DummyCacheIdListModel(List<CacheUtil.CacheId> content) {
            this.content = content;
        }

        @Override
        public int getSize() {
            return this.content.size();
        }

        @Override
        public CacheUtil.CacheId getElementAt(int index) {
            return this.content.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    private static class DummyListSelectionListenerWithModel
    implements ListSelectionListener {
        private final JTextArea info;
        private final JList<CacheUtil.CacheId> apps;
        private final JButton delete;

        public DummyListSelectionListenerWithModel(JTextArea info, JList<CacheUtil.CacheId> apps, JButton delete) {
            this.info = info;
            this.apps = apps;
            this.delete = delete;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.info.setText("");
            if (this.apps.getSelectedValue() != null) {
                for (Object[] o : this.apps.getSelectedValue().getFiles()) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < o.length; ++i) {
                        Object object = o[i];
                        if (object == null) {
                            object = "??";
                        }
                        sb.append(object.toString()).append(" ;  ");
                    }
                    this.info.setText(this.info.getText() + sb.toString() + "\n");
                }
                this.delete.setEnabled(true);
                this.delete.setText(Translator.R("TIFPDeleteFiles") + " - " + this.apps.getSelectedValue().getFiles().size());
            } else {
                this.delete.setEnabled(false);
                this.delete.setText(Translator.R("TIFPDeleteFiles"));
            }
        }
    }
}

