/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJCompressor;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJScalingFactor;
import org.libjpegturbo.turbojpeg.YUVImage;

final class TJUnitTest {
    static final String CLASS_NAME = new TJUnitTest().getClass().getName();
    static final String[] SUBNAME_LONG = new String[]{"4:4:4", "4:2:2", "4:2:0", "GRAY", "4:4:0", "4:1:1", "4:4:1"};
    static final String[] SUBNAME = new String[]{"444", "422", "420", "GRAY", "440", "411", "441"};
    static final String[] PIXFORMATSTR = new String[]{"RGB", "BGR", "RGBX", "BGRX", "XBGR", "XRGB", "Grayscale", "RGBA", "BGRA", "ABGR", "ARGB", "CMYK"};
    static final int[] FORMATS_3SAMPLE = new int[]{0, 1};
    static final int[] FORMATS_3BYTEBI = new int[]{5};
    static final int[] FORMATS_4SAMPLE = new int[]{2, 3, 4, 5, 11};
    static final int[] FORMATS_4BYTEBI = new int[]{4, 1, 6, 7, 2, 3};
    static final int[] FORMATS_GRAY = new int[]{6};
    static final int[] FORMATS_GRAYBI = new int[]{10};
    static final int[] FORMATS_RGB = new int[]{0};
    private static boolean doYUV = false;
    private static boolean lossless = false;
    private static int psv = 1;
    private static int yuvAlign = 4;
    private static int precision = 8;
    private static int sampleSize;
    private static int maxSample;
    private static int tolerance;
    private static int redToY;
    private static int yellowToY;
    private static boolean bi;
    private static int exitStatus;
    private static String uniqueID;

    private TJUnitTest() {
    }

    static void usage() {
        System.out.println("\nUSAGE: java " + CLASS_NAME + " [options]\n");
        System.out.println("Options:");
        System.out.println("-yuv = test YUV encoding/compression/decompression/decoding");
        System.out.println("       (8-bit data precision only)");
        System.out.println("-noyuvpad = do not pad each row in each Y, U, and V plane to the nearest");
        System.out.println("            multiple of 4 bytes");
        System.out.println("-precision N = test N-bit data precision (N=2..16; default is 8; if N is not 8");
        System.out.println("               or 12, then -lossless is implied)");
        System.out.println("-lossless = test lossless JPEG compression/decompression");
        System.out.println("-bi = test BufferedImage I/O (8-bit data precision only)\n");
        System.exit(1);
    }

    static int biTypePF(int n) {
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        switch (n) {
            case 5: {
                return 1;
            }
            case 6: 
            case 7: {
                return 9;
            }
            case 10: {
                return 6;
            }
            case 4: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: 
            case 3: {
                return 8;
            }
        }
        return 0;
    }

    static String biTypeStr(int n) {
        switch (n) {
            case 5: {
                return "3BYTE_BGR";
            }
            case 6: {
                return "4BYTE_ABGR";
            }
            case 7: {
                return "4BYTE_ABGR_PRE";
            }
            case 10: {
                return "BYTE_GRAY";
            }
            case 4: {
                return "INT_BGR";
            }
            case 1: {
                return "INT_RGB";
            }
            case 2: {
                return "INT_ARGB";
            }
            case 3: {
                return "INT_ARGB_PRE";
            }
        }
        return "Unknown";
    }

    static void fillArray(Object object, int n) {
        if (precision <= 8) {
            Arrays.fill((byte[])object, (byte)n);
        } else {
            Arrays.fill((short[])object, (short)n);
        }
    }

    static void setVal(Object object, int n, int n2) {
        if (precision <= 8) {
            ((byte[])object)[n] = (byte)n2;
        } else {
            ((short[])object)[n] = (short)n2;
        }
    }

    static void initBuf(Object object, int n, int n2, int n3, int n4, boolean bl) throws Exception {
        int n5 = TJ.getRedOffset(n4);
        int n6 = TJ.getGreenOffset(n4);
        int n7 = TJ.getBlueOffset(n4);
        int n8 = TJ.getAlphaOffset(n4);
        int n9 = TJ.getPixelSize(n4);
        int n10 = 16;
        if (n4 == 6) {
            TJUnitTest.fillArray(object, 0);
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n11 = bl ? n2 * (n3 - i - 1) + j : n2 * i + j;
                    if ((i / 8 + j / 8) % 2 == 0) {
                        TJUnitTest.setVal(object, n11, i < n10 ? maxSample : 0);
                        continue;
                    }
                    TJUnitTest.setVal(object, n11, i < n10 ? redToY : yellowToY);
                }
            }
            return;
        }
        if (n4 == 11) {
            TJUnitTest.fillArray(object, maxSample);
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n12 = bl ? (n3 - i - 1) * n + j : i * n + j;
                    if ((i / 8 + j / 8) % 2 == 0) {
                        if (i < n10) continue;
                        TJUnitTest.setVal(object, n12 * n9 + 3, 0);
                        continue;
                    }
                    TJUnitTest.setVal(object, n12 * n9 + 2, 0);
                    if (i >= n10) continue;
                    TJUnitTest.setVal(object, n12 * n9 + 1, 0);
                }
            }
            return;
        }
        TJUnitTest.fillArray(object, 0);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                int n13 = bl ? n2 * (n3 - i - 1) + j * n9 : n2 * i + j * n9;
                if ((i / 8 + j / 8) % 2 == 0) {
                    if (i < n10) {
                        TJUnitTest.setVal(object, n13 + n5, maxSample);
                        TJUnitTest.setVal(object, n13 + n6, maxSample);
                        TJUnitTest.setVal(object, n13 + n7, maxSample);
                    }
                } else {
                    TJUnitTest.setVal(object, n13 + n5, maxSample);
                    if (i >= n10) {
                        TJUnitTest.setVal(object, n13 + n6, maxSample);
                    }
                }
                if (n8 < 0) continue;
                TJUnitTest.setVal(object, n13 + n8, maxSample);
            }
        }
    }

    static void initIntBuf(int[] nArray, int n, int n2, int n3, int n4, boolean bl) throws Exception {
        int n5 = TJ.getRedOffset(n4) * 8;
        int n6 = TJ.getGreenOffset(n4) * 8;
        int n7 = TJ.getBlueOffset(n4) * 8;
        int n8 = TJ.getAlphaOffset(n4) * 8;
        int n9 = 16;
        Arrays.fill(nArray, 0);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                int n10 = bl ? n2 * (n3 - i - 1) + j : n2 * i + j;
                if ((i / 8 + j / 8) % 2 == 0) {
                    if (i < n9) {
                        int n11 = n10;
                        nArray[n11] = nArray[n11] | 255 << n5;
                        int n12 = n10;
                        nArray[n12] = nArray[n12] | 255 << n6;
                        int n13 = n10;
                        nArray[n13] = nArray[n13] | 255 << n7;
                    }
                } else {
                    int n14 = n10;
                    nArray[n14] = nArray[n14] | 255 << n5;
                    if (i >= n9) {
                        int n15 = n10;
                        nArray[n15] = nArray[n15] | 255 << n6;
                    }
                }
                if (n8 < 0) continue;
                int n16 = n10;
                nArray[n16] = nArray[n16] | 255 << n8;
            }
        }
    }

    static void initImg(BufferedImage bufferedImage, int n, boolean bl) throws Exception {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n2 = bufferedImage.getType();
        if (n2 == 1 || n2 == 4 || n2 == 2 || n2 == 3) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            int n3 = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            TJUnitTest.initIntBuf(nArray, bufferedImage.getWidth(), n3, bufferedImage.getHeight(), n, bl);
        } else {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)bufferedImage.getSampleModel();
            int n4 = componentSampleModel.getScanlineStride();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            TJUnitTest.initBuf(byArray, bufferedImage.getWidth(), n4, bufferedImage.getHeight(), n, bl);
        }
    }

    static void checkVal(int n, int n2, int n3, String string, int n4) throws Exception {
        int n5 = n3 = n3 < 0 ? n3 + 256 : n3;
        if (n3 < n4 - tolerance || n3 > n4 + tolerance) {
            throw new Exception("Comp. " + string + " at " + n + "," + n2 + " should be " + n4 + ", not " + n3);
        }
    }

    static void checkVal0(int n, int n2, int n3, String string) throws Exception {
        int n4 = n3 = n3 < 0 ? n3 + 256 : n3;
        if (n3 > tolerance) {
            throw new Exception("Comp. " + string + " at " + n + "," + n2 + " should be 0, not " + n3);
        }
    }

    static void checkValMax(int n, int n2, int n3, String string) throws Exception {
        int n4 = n3 = n3 < 0 ? n3 + 256 : n3;
        if (n3 < maxSample - tolerance) {
            throw new Exception("Comp. " + string + " at " + n + "," + n2 + " should be " + maxSample + ", not " + n3);
        }
    }

    static int getVal(Object object, int n, int n2) {
        int n3 = n2 <= 8 ? ((byte[])object)[n] : ((short[])object)[n];
        if (n3 < 0) {
            n3 += 1 << n2;
        }
        return n3;
    }

    static boolean checkBuf(Object object, int n, int n2, int n3, int n4, int n5, TJScalingFactor tJScalingFactor, boolean bl) throws Exception {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = TJ.getRedOffset(n4);
        int n12 = TJ.getGreenOffset(n4);
        int n13 = TJ.getBlueOffset(n4);
        int n14 = TJ.getAlphaOffset(n4);
        int n15 = TJ.getPixelSize(n4);
        boolean bl2 = true;
        int n16 = 16 * tJScalingFactor.getNum() / tJScalingFactor.getDenom();
        int n17 = 8 * tJScalingFactor.getNum() / tJScalingFactor.getDenom();
        try {
            if (n4 == 6) {
                n13 = 0;
                n12 = 0;
                n11 = 0;
            }
            if (n4 == 11) {
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n; ++j) {
                        int n18 = bl ? (n3 - i - 1) * n + j : i * n + j;
                        int n19 = TJUnitTest.getVal(object, n18 * n15, precision);
                        int n20 = TJUnitTest.getVal(object, n18 * n15 + 1, precision);
                        int n21 = TJUnitTest.getVal(object, n18 * n15 + 2, precision);
                        int n22 = TJUnitTest.getVal(object, n18 * n15 + 3, precision);
                        TJUnitTest.checkValMax(i, j, n19, "C");
                        if ((i / n17 + j / n17) % 2 == 0) {
                            TJUnitTest.checkValMax(i, j, n20, "M");
                            TJUnitTest.checkValMax(i, j, n21, "Y");
                            if (i < n16) {
                                TJUnitTest.checkValMax(i, j, n22, "K");
                                continue;
                            }
                            TJUnitTest.checkVal0(i, j, n22, "K");
                            continue;
                        }
                        TJUnitTest.checkVal0(i, j, n21, "Y");
                        TJUnitTest.checkValMax(i, j, n22, "K");
                        if (i < n16) {
                            TJUnitTest.checkVal0(i, j, n20, "M");
                            continue;
                        }
                        TJUnitTest.checkValMax(i, j, n20, "M");
                    }
                }
                return true;
            }
            for (n10 = 0; n10 < n16; ++n10) {
                for (n9 = 0; n9 < n; ++n9) {
                    int n23 = bl ? n2 * (n3 - n10 - 1) + n9 * n15 : n2 * n10 + n9 * n15;
                    int n24 = TJUnitTest.getVal(object, n23 + n11, precision);
                    n8 = TJUnitTest.getVal(object, n23 + n12, precision);
                    n7 = TJUnitTest.getVal(object, n23 + n13, precision);
                    int n25 = n6 = n14 >= 0 ? TJUnitTest.getVal(object, n23 + n14, precision) : maxSample;
                    if ((n10 / n17 + n9 / n17) % 2 == 0) {
                        if (n10 < n16) {
                            TJUnitTest.checkValMax(n10, n9, n24, "R");
                            TJUnitTest.checkValMax(n10, n9, n8, "G");
                            TJUnitTest.checkValMax(n10, n9, n7, "B");
                        } else {
                            TJUnitTest.checkVal0(n10, n9, n24, "R");
                            TJUnitTest.checkVal0(n10, n9, n8, "G");
                            TJUnitTest.checkVal0(n10, n9, n7, "B");
                        }
                    } else if (n5 == 3) {
                        if (n10 < n16) {
                            TJUnitTest.checkVal(n10, n9, n24, "R", redToY);
                            TJUnitTest.checkVal(n10, n9, n8, "G", redToY);
                            TJUnitTest.checkVal(n10, n9, n7, "B", redToY);
                        } else {
                            TJUnitTest.checkVal(n10, n9, n24, "R", yellowToY);
                            TJUnitTest.checkVal(n10, n9, n8, "G", yellowToY);
                            TJUnitTest.checkVal(n10, n9, n7, "B", yellowToY);
                        }
                    } else {
                        TJUnitTest.checkValMax(n10, n9, n24, "R");
                        if (n10 < n16) {
                            TJUnitTest.checkVal0(n10, n9, n8, "G");
                        } else {
                            TJUnitTest.checkValMax(n10, n9, n8, "G");
                        }
                        TJUnitTest.checkVal0(n10, n9, n7, "B");
                    }
                    TJUnitTest.checkValMax(n10, n9, n6, "A");
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\n" + exception.getMessage());
            bl2 = false;
        }
        if (!bl2) {
            for (n10 = 0; n10 < n3; ++n10) {
                for (n9 = 0; n9 < n; ++n9) {
                    int n26;
                    if (n4 == 11) {
                        n26 = TJUnitTest.getVal(object, n2 * n10 + n9 * n15, precision);
                        n8 = TJUnitTest.getVal(object, n2 * n10 + n9 * n15 + 1, precision);
                        n7 = TJUnitTest.getVal(object, n2 * n10 + n9 * n15 + 2, precision);
                        n6 = TJUnitTest.getVal(object, n2 * n10 + n9 * n15 + 3, precision);
                        System.out.format("%3d/%3d/%3d/%3d ", n26, n8, n7, n6);
                        continue;
                    }
                    n26 = TJUnitTest.getVal(object, n2 * n10 + n9 * n15 + n11, precision);
                    n8 = TJUnitTest.getVal(object, n2 * n10 + n9 * n15 + n12, precision);
                    n7 = TJUnitTest.getVal(object, n2 * n10 + n9 * n15 + n13, precision);
                    System.out.format("%3d/%3d/%3d ", n26, n8, n7);
                }
                System.out.print("\n");
            }
        }
        return bl2;
    }

    static boolean checkIntBuf(int[] nArray, int n, int n2, int n3, int n4, int n5, TJScalingFactor tJScalingFactor, boolean bl) throws Exception {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = TJ.getRedOffset(n4) * 8;
        int n11 = TJ.getGreenOffset(n4) * 8;
        int n12 = TJ.getBlueOffset(n4) * 8;
        int n13 = TJ.getAlphaOffset(n4) * 8;
        boolean bl2 = true;
        int n14 = 16 * tJScalingFactor.getNum() / tJScalingFactor.getDenom();
        int n15 = 8 * tJScalingFactor.getNum() / tJScalingFactor.getDenom();
        try {
            for (n9 = 0; n9 < n14; ++n9) {
                for (n8 = 0; n8 < n; ++n8) {
                    int n16;
                    int n17 = bl ? n2 * (n3 - n9 - 1) + n8 : n2 * n9 + n8;
                    int n18 = nArray[n17] >> n10 & 0xFF;
                    n7 = nArray[n17] >> n11 & 0xFF;
                    n6 = nArray[n17] >> n12 & 0xFF;
                    int n19 = n16 = n13 >= 0 ? nArray[n17] >> n13 & 0xFF : 255;
                    if ((n9 / n15 + n8 / n15) % 2 == 0) {
                        if (n9 < n14) {
                            TJUnitTest.checkValMax(n9, n8, n18, "R");
                            TJUnitTest.checkValMax(n9, n8, n7, "G");
                            TJUnitTest.checkValMax(n9, n8, n6, "B");
                        } else {
                            TJUnitTest.checkVal0(n9, n8, n18, "R");
                            TJUnitTest.checkVal0(n9, n8, n7, "G");
                            TJUnitTest.checkVal0(n9, n8, n6, "B");
                        }
                    } else if (n5 == 3) {
                        if (n9 < n14) {
                            TJUnitTest.checkVal(n9, n8, n18, "R", 76);
                            TJUnitTest.checkVal(n9, n8, n7, "G", 76);
                            TJUnitTest.checkVal(n9, n8, n6, "B", 76);
                        } else {
                            TJUnitTest.checkVal(n9, n8, n18, "R", 226);
                            TJUnitTest.checkVal(n9, n8, n7, "G", 226);
                            TJUnitTest.checkVal(n9, n8, n6, "B", 226);
                        }
                    } else {
                        TJUnitTest.checkValMax(n9, n8, n18, "R");
                        if (n9 < n14) {
                            TJUnitTest.checkVal0(n9, n8, n7, "G");
                        } else {
                            TJUnitTest.checkValMax(n9, n8, n7, "G");
                        }
                        TJUnitTest.checkVal0(n9, n8, n6, "B");
                    }
                    TJUnitTest.checkValMax(n9, n8, n16, "A");
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\n" + exception.getMessage());
            bl2 = false;
        }
        if (!bl2) {
            for (n9 = 0; n9 < n3; ++n9) {
                for (n8 = 0; n8 < n; ++n8) {
                    int n20 = nArray[n2 * n9 + n8] >> n10 & 0xFF;
                    n7 = nArray[n2 * n9 + n8] >> n11 & 0xFF;
                    n6 = nArray[n2 * n9 + n8] >> n12 & 0xFF;
                    if (n20 < 0) {
                        n20 += 256;
                    }
                    if (n7 < 0) {
                        n7 += 256;
                    }
                    if (n6 < 0) {
                        n6 += 256;
                    }
                    System.out.format("%3d/%3d/%3d ", n20, n7, n6);
                }
                System.out.print("\n");
            }
        }
        return bl2;
    }

    static boolean checkImg(BufferedImage bufferedImage, int n, int n2, TJScalingFactor tJScalingFactor, boolean bl) throws Exception {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = bufferedImage.getType();
        if (n3 == 1 || n3 == 4 || n3 == 2 || n3 == 3) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            int n4 = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            return TJUnitTest.checkIntBuf(nArray, bufferedImage.getWidth(), n4, bufferedImage.getHeight(), n, n2, tJScalingFactor, bl);
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)bufferedImage.getSampleModel();
        int n5 = componentSampleModel.getScanlineStride();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        return TJUnitTest.checkBuf(byArray, bufferedImage.getWidth(), n5, bufferedImage.getHeight(), n, n2, tJScalingFactor, bl);
    }

    static int pad(int n, int n2) {
        return n + n2 - 1 & ~(n2 - 1);
    }

    static boolean checkBufYUV(byte[] byArray, int n, int n2, int n3, int n4, TJScalingFactor tJScalingFactor) throws Exception {
        int n5;
        int n6;
        int n7 = TJ.getMCUWidth(n4) / 8;
        int n8 = TJ.getMCUHeight(n4) / 8;
        int n9 = TJUnitTest.pad(n2, n7);
        int n10 = TJUnitTest.pad(n3, n8);
        int n11 = n9 / n7;
        int n12 = n10 / n8;
        int n13 = TJUnitTest.pad(n9, yuvAlign);
        int n14 = TJUnitTest.pad(n11, yuvAlign);
        boolean bl = true;
        int n15 = n13 * n10 + (n4 == 3 ? 0 : n14 * n12 * 2);
        int n16 = 16 * tJScalingFactor.getNum() / tJScalingFactor.getDenom();
        int n17 = 8 * tJScalingFactor.getNum() / tJScalingFactor.getDenom();
        try {
            byte by;
            if (n != n15) {
                throw new Exception("Incorrect size " + n + ".  Should be " + n15);
            }
            for (n6 = 0; n6 < n10; ++n6) {
                for (n5 = 0; n5 < n9; ++n5) {
                    by = byArray[n13 * n6 + n5];
                    if ((n6 / n17 + n5 / n17) % 2 == 0) {
                        if (n6 < n16) {
                            TJUnitTest.checkValMax(n6, n5, by, "Y");
                            continue;
                        }
                        TJUnitTest.checkVal0(n6, n5, by, "Y");
                        continue;
                    }
                    if (n6 < n16) {
                        TJUnitTest.checkVal(n6, n5, by, "Y", 76);
                        continue;
                    }
                    TJUnitTest.checkVal(n6, n5, by, "Y", 226);
                }
            }
            if (n4 != 3) {
                n16 = 16 / n8 * tJScalingFactor.getNum() / tJScalingFactor.getDenom();
                for (n6 = 0; n6 < n12; ++n6) {
                    for (n5 = 0; n5 < n11; ++n5) {
                        by = byArray[n13 * n10 + (n14 * n6 + n5)];
                        byte by2 = byArray[n13 * n10 + n14 * n12 + (n14 * n6 + n5)];
                        if ((n6 * n8 / n17 + n5 * n7 / n17) % 2 == 0) {
                            TJUnitTest.checkVal(n6, n5, by, "U", 128);
                            TJUnitTest.checkVal(n6, n5, by2, "V", 128);
                            continue;
                        }
                        if (n6 < n16) {
                            TJUnitTest.checkVal(n6, n5, by, "U", 85);
                            TJUnitTest.checkValMax(n6, n5, by2, "V");
                            continue;
                        }
                        TJUnitTest.checkVal0(n6, n5, by, "U");
                        TJUnitTest.checkVal(n6, n5, by2, "V", 149);
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\n" + exception.getMessage());
            bl = false;
        }
        if (!bl) {
            for (n6 = 0; n6 < n10; ++n6) {
                for (n5 = 0; n5 < n9; ++n5) {
                    int n18 = byArray[n13 * n6 + n5];
                    if (n18 < 0) {
                        n18 += 256;
                    }
                    System.out.format("%3d ", n18);
                }
                System.out.print("\n");
            }
            System.out.print("\n");
            for (n6 = 0; n6 < n12; ++n6) {
                for (n5 = 0; n5 < n11; ++n5) {
                    int n19 = byArray[n13 * n10 + (n14 * n6 + n5)];
                    if (n19 < 0) {
                        n19 += 256;
                    }
                    System.out.format("%3d ", n19);
                }
                System.out.print("\n");
            }
            System.out.print("\n");
            for (n6 = 0; n6 < n12; ++n6) {
                for (n5 = 0; n5 < n11; ++n5) {
                    int n20 = byArray[n13 * n10 + n14 * n12 + (n14 * n6 + n5)];
                    if (n20 < 0) {
                        n20 += 256;
                    }
                    System.out.format("%3d ", n20);
                }
                System.out.print("\n");
            }
        }
        return bl;
    }

    static void writeJPEG(byte[] byArray, int n, String string) throws Exception {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray, 0, n);
        fileOutputStream.close();
    }

    static int compTest(TJCompressor tJCompressor, byte[] byArray, int n, int n2, int n3, String string) throws Exception {
        Object object;
        String string2;
        Object object2;
        String string3;
        Object[] objectArray = null;
        BufferedImage bufferedImage = null;
        boolean bl = tJCompressor.get(1) == 1;
        int n4 = tJCompressor.get(4);
        int n5 = tJCompressor.get(3);
        int n6 = tJCompressor.get(16);
        String string4 = bl ? "BU" : "TD";
        String string5 = bl ? "Bottom-Up" : "Top-Down ";
        int n7 = 0;
        int n8 = n3;
        if (bi) {
            n3 = TJUnitTest.biTypePF(n8);
            string3 = TJUnitTest.biTypeStr(n8);
            object2 = string3 + " (" + PIXFORMATSTR[n3] + ")";
        } else {
            string3 = PIXFORMATSTR[n3];
            object2 = string3;
        }
        int n9 = TJ.getPixelSize(n3);
        if (bi) {
            bufferedImage = new BufferedImage(n, n2, n8);
            TJUnitTest.initImg(bufferedImage, n3, bl);
            string2 = string + "_enc" + precision + "_" + string3 + "_" + string4 + "_" + SUBNAME[n4] + "_Q" + n5 + ".png";
            object = new File(string2);
            ImageIO.write((RenderedImage)bufferedImage, "png", (File)object);
            tJCompressor.setSourceImage(bufferedImage, 0, 0, 0, 0);
        } else {
            objectArray = precision <= 8 ? new byte[n * n2 * n9 + 1] : (Object[])new short[n * n2 * n9 + 1];
            TJUnitTest.initBuf(objectArray, n, n * n9, n2, n3, bl);
            if (precision <= 8) {
                tJCompressor.setSourceImage((byte[])objectArray, 0, 0, n, 0, n2, n3);
            } else if (precision <= 12) {
                tJCompressor.setSourceImage12((short[])objectArray, 0, 0, n, 0, n2, n3);
            } else {
                tJCompressor.setSourceImage16((short[])objectArray, 0, 0, n, 0, n2, n3);
            }
        }
        Arrays.fill(byArray, (byte)0);
        if (doYUV) {
            System.out.format("%s %s -> YUV %s ... ", object2, string5, SUBNAME_LONG[n4]);
            object = tJCompressor.encodeYUV(yuvAlign);
            if (TJUnitTest.checkBufYUV(((YUVImage)object).getBuf(), ((YUVImage)object).getSize(), n, n2, n4, new TJScalingFactor(1, 1))) {
                System.out.print("Passed.\n");
            } else {
                System.out.print("FAILED!\n");
                exitStatus = -1;
            }
            System.out.format("YUV %s %s -> JPEG Q%d ... ", SUBNAME_LONG[n4], string5, n5);
            tJCompressor.setSourceImage((YUVImage)object);
        } else if (lossless) {
            tJCompressor.set(7, precision);
            System.out.format("%s %s -> LOSSLESS PSV%d ... ", object2, string5, n6);
        } else {
            System.out.format("%s %s -> %s Q%d ... ", object2, string5, SUBNAME_LONG[n4], n5);
        }
        tJCompressor.compress(byArray);
        n7 = tJCompressor.getCompressedSize();
        string2 = lossless ? string + "_enc" + precision + "_" + string3 + "_" + string4 + "_LOSSLESS_PSV" + n6 + ".jpg" : string + "_enc" + precision + "_" + string3 + "_" + string4 + "_" + SUBNAME[n4] + "_Q" + n5 + ".jpg";
        TJUnitTest.writeJPEG(byArray, n7, string2);
        System.out.println("Done.\n  Result in " + string2);
        return n7;
    }

    static void decompTest(TJDecompressor tJDecompressor, byte[] byArray, int n, int n2, int n3, int n4, String string, int n5, TJScalingFactor tJScalingFactor) throws Exception {
        Object object;
        Object object2;
        String string2;
        boolean bl = tJDecompressor.get(1) == 1;
        String string3 = bl ? "Bottom-Up" : "Top-Down ";
        int n6 = tJScalingFactor.getScaled(n2);
        int n7 = tJScalingFactor.getScaled(n3);
        int n8 = n4;
        BufferedImage bufferedImage = null;
        Object[] objectArray = null;
        if (bi) {
            n4 = TJUnitTest.biTypePF(n8);
            string2 = TJUnitTest.biTypeStr(n8);
            object2 = string2 + " (" + PIXFORMATSTR[n4] + ")";
        } else {
            string2 = PIXFORMATSTR[n4];
            object2 = string2;
        }
        tJDecompressor.setSourceImage(byArray, n);
        tJDecompressor.setScalingFactor(tJScalingFactor);
        if (lossless && n5 != 0 && n5 != 3) {
            n5 = 0;
        }
        if (tJDecompressor.getWidth() != n2 || tJDecompressor.getHeight() != n3 || tJDecompressor.get(4) != n5) {
            throw new Exception("Incorrect JPEG header");
        }
        if (doYUV) {
            System.out.format("JPEG -> YUV %s ", SUBNAME_LONG[n5]);
            if (!tJScalingFactor.isOne()) {
                System.out.format("%d/%d ... ", tJScalingFactor.getNum(), tJScalingFactor.getDenom());
            } else {
                System.out.print("... ");
            }
            object = tJDecompressor.decompressToYUV(yuvAlign);
            if (TJUnitTest.checkBufYUV(((YUVImage)object).getBuf(), ((YUVImage)object).getSize(), n6, n7, n5, tJScalingFactor)) {
                System.out.print("Passed.\n");
            } else {
                System.out.print("FAILED!\n");
                exitStatus = -1;
            }
            System.out.format("YUV %s -> %s %s ... ", SUBNAME_LONG[n5], object2, string3);
            tJDecompressor.setSourceImage((YUVImage)object);
        } else {
            System.out.format("JPEG -> %s %s ", object2, string3);
            if (!tJScalingFactor.isOne()) {
                System.out.format("%d/%d ... ", tJScalingFactor.getNum(), tJScalingFactor.getDenom());
            } else {
                System.out.print("... ");
            }
        }
        if (bi) {
            bufferedImage = tJDecompressor.decompress8(n8);
        } else {
            objectArray = precision <= 8 ? tJDecompressor.decompress8(0, n4) : (precision <= 12 ? (Object[])tJDecompressor.decompress12(0, n4) : (Object[])tJDecompressor.decompress16(0, n4));
        }
        if (bi) {
            String string4 = string + "_dec_" + string2 + "_" + (bl ? "BU" : "TD") + "_" + SUBNAME[n5] + "_" + (double)tJScalingFactor.getNum() / (double)tJScalingFactor.getDenom() + "x.png";
            object = new File(string4);
            ImageIO.write((RenderedImage)bufferedImage, "png", (File)object);
        }
        if (bi && TJUnitTest.checkImg(bufferedImage, n4, n5, tJScalingFactor, bl) || !bi && TJUnitTest.checkBuf(objectArray, n6, n6 * TJ.getPixelSize(n4), n7, n4, n5, tJScalingFactor, bl)) {
            System.out.print("Passed.\n");
        } else {
            System.out.print("FAILED!\n");
            exitStatus = -1;
        }
    }

    static void decompTest(TJDecompressor tJDecompressor, byte[] byArray, int n, int n2, int n3, int n4, String string, int n5) throws Exception {
        if (lossless) {
            TJUnitTest.decompTest(tJDecompressor, byArray, n, n2, n3, n4, string, n5, TJ.UNSCALED);
            return;
        }
        TJScalingFactor[] tJScalingFactorArray = TJ.getScalingFactors();
        for (int i = 0; i < tJScalingFactorArray.length; ++i) {
            int n6 = tJScalingFactorArray[i].getNum();
            int n7 = tJScalingFactorArray[i].getDenom();
            if (n5 != 0 && n5 != 3 && (n5 != 5 && n5 != 6 || n6 != 1 || n7 != 2 && n7 != 1) && (n5 == 5 || n5 == 6 || n6 != 1 || n7 != 4 && n7 != 2 && n7 != 1)) continue;
            TJUnitTest.decompTest(tJDecompressor, byArray, n, n2, n3, n4, string, n5, tJScalingFactorArray[i]);
        }
    }

    static void doTest(int n, int n2, int[] nArray, int n3, String string) throws Exception {
        TJCompressor tJCompressor = null;
        TJDecompressor tJDecompressor = null;
        if (lossless && n3 != 3) {
            n3 = 0;
        }
        byte[] byArray = new byte[TJ.bufSize(n, n2, n3)];
        try {
            tJCompressor = new TJCompressor();
            tJDecompressor = new TJDecompressor();
            if (lossless) {
                tJCompressor.set(15, 1);
                tJCompressor.set(16, (psv++ - 1) % 7 + 1);
            } else {
                tJCompressor.set(3, 100);
                if (n3 == 1 || n3 == 2 || n3 == 4 || n3 == 5 || n3 == 6) {
                    tJDecompressor.set(9, 1);
                }
            }
            tJCompressor.set(4, n3);
            for (int n4 : nArray) {
                if (n4 < 0) continue;
                for (int i = 0; i < 2; ++i) {
                    tJCompressor.set(1, i == 1 ? 1 : 0);
                    tJDecompressor.set(1, i == 1 ? 1 : 0);
                    int n5 = TJUnitTest.compTest(tJCompressor, byArray, n, n2, n4, string);
                    TJUnitTest.decompTest(tJDecompressor, byArray, n5, n, n2, n4, string, n3);
                    if (n4 >= 2 && n4 <= 5 && !bi) {
                        System.out.print("\n");
                        TJUnitTest.decompTest(tJDecompressor, byArray, n5, n, n2, n4 + 5, string, n3);
                    }
                    System.out.print("\n");
                }
            }
            System.out.print("--------------------\n\n");
        }
        catch (Exception exception) {
            if (tJCompressor != null) {
                tJCompressor.close();
            }
            if (tJDecompressor != null) {
                tJDecompressor.close();
            }
            throw exception;
        }
        if (tJCompressor != null) {
            tJCompressor.close();
        }
        if (tJDecompressor != null) {
            tJDecompressor.close();
        }
    }

    static void overflowTest() throws Exception {
        int n = 0;
        boolean bl = false;
        try {
            bl = false;
            n = TJ.bufSize(18919, 18919, 0);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl || n != 0) {
            throw new Exception("TJ.bufSize() overflow");
        }
        try {
            bl = false;
            n = TJ.bufSizeYUV(26755, 1, 26755, 0);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl || n != 0) {
            throw new Exception("TJ.bufSizeYUV() overflow");
        }
        try {
            bl = false;
            n = TJ.bufSizeYUV(26754, 3, 26754, 0);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl || n != 0) {
            throw new Exception("TJ.bufSizeYUV() overflow");
        }
        try {
            bl = false;
            n = TJ.bufSizeYUV(26754, -1, 26754, 0);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl || n != 0) {
            throw new Exception("TJ.bufSizeYUV() overflow");
        }
        try {
            bl = false;
            n = TJ.planeSizeYUV(0, 46341, 0, 46341, 0);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl || n != 0) {
            throw new Exception("TJ.planeSizeYUV() overflow");
        }
        try {
            bl = false;
            n = TJ.planeWidth(0, Integer.MAX_VALUE, 2);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl || n != 0) {
            throw new Exception("TJ.planeWidth() overflow");
        }
        try {
            bl = false;
            n = TJ.planeHeight(0, Integer.MAX_VALUE, 2);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl || n != 0) {
            throw new Exception("TJ.planeHeight() overflow");
        }
    }

    static void bufSizeTest() throws Exception {
        int n = 7;
        byte[] byArray = null;
        YUVImage yUVImage = null;
        TJCompressor tJCompressor = null;
        Random random = new Random();
        try {
            tJCompressor = new TJCompressor();
            if (lossless) {
                tJCompressor.set(7, precision);
                tJCompressor.set(15, 1);
                tJCompressor.set(16, (psv++ - 1) % 7 + 1);
                n = 1;
            } else {
                tJCompressor.set(3, 100);
            }
            System.out.println("Buffer size regression test");
            for (int i = 0; i < n; ++i) {
                tJCompressor.set(4, i);
                for (int j = 1; j < 48; ++j) {
                    int n2 = j == 1 ? 2048 : 48;
                    for (int k = 1; k < n2; ++k) {
                        int n3;
                        if (k % 100 == 0) {
                            System.out.format("%04d x %04d\b\b\b\b\b\b\b\b\b\b\b", j, k);
                        }
                        byte[] byArray2 = new byte[j * k * 4];
                        if (doYUV) {
                            yUVImage = new YUVImage(j, yuvAlign, k, i);
                        } else {
                            byArray = new byte[TJ.bufSize(j, k, i)];
                        }
                        for (n3 = 0; n3 < j * k * 4; ++n3) {
                            byArray2[n3] = (byte)(random.nextInt(2) * 255);
                        }
                        tJCompressor.setSourceImage(byArray2, 0, 0, j, 0, k, 3);
                        if (doYUV) {
                            tJCompressor.encodeYUV(yUVImage);
                        } else {
                            tJCompressor.compress(byArray);
                        }
                        byArray2 = new byte[k * j * 4];
                        if (doYUV) {
                            yUVImage = new YUVImage(k, yuvAlign, j, i);
                        } else {
                            byArray = new byte[TJ.bufSize(k, j, i)];
                        }
                        for (n3 = 0; n3 < k * j * 4; ++n3) {
                            byArray2[n3] = (byte)(random.nextInt(2) * 255);
                        }
                        tJCompressor.setSourceImage(byArray2, 0, 0, k, 0, j, 3);
                        if (doYUV) {
                            tJCompressor.encodeYUV(yUVImage);
                            continue;
                        }
                        tJCompressor.compress(byArray);
                    }
                    yUVImage = null;
                    byArray = null;
                    System.gc();
                }
            }
            System.out.println("Done.      ");
        }
        catch (Exception exception) {
            if (tJCompressor != null) {
                tJCompressor.close();
            }
            throw exception;
        }
        if (tJCompressor != null) {
            tJCompressor.close();
        }
    }

    static void rgbToCMYK(int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        double d = 1.0 - (double)n / (double)maxSample;
        double d2 = 1.0 - (double)n2 / (double)maxSample;
        double d3 = 1.0 - (double)n3 / (double)maxSample;
        double d4 = Math.min(Math.min(d, d2), d3);
        if (d4 == 1.0) {
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        } else {
            d = (d - d4) / (1.0 - d4);
            d2 = (d2 - d4) / (1.0 - d4);
            d3 = (d3 - d4) / (1.0 - d4);
        }
        nArray[0] = (int)((double)maxSample - d * (double)maxSample + 0.5);
        nArray2[0] = (int)((double)maxSample - d2 * (double)maxSample + 0.5);
        nArray3[0] = (int)((double)maxSample - d3 * (double)maxSample + 0.5);
        nArray4[0] = (int)((double)maxSample - d4 * (double)maxSample + 0.5);
    }

    static void initBitmap(Object object, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = TJ.getRedOffset(n4);
        int n6 = TJ.getGreenOffset(n4);
        int n7 = TJ.getBlueOffset(n4);
        int n8 = TJ.getPixelSize(n4);
        for (int i = 0; i < n3; ++i) {
            int n9 = bl ? n3 - i - 1 : i;
            for (int j = 0; j < n; ++j) {
                int n10 = j * (maxSample + 1) / n % (maxSample + 1);
                int n11 = i * (maxSample + 1) / n3 % (maxSample + 1);
                int n12 = (i * (maxSample + 1) / n3 + j * (maxSample + 1) / n) % (maxSample + 1);
                for (int k = 0; k < n8; ++k) {
                    TJUnitTest.setVal(object, n9 * n2 + j * n8 + k, 0);
                }
                if (n4 == 6) {
                    TJUnitTest.setVal(object, n9 * n2 + j * n8, n12);
                    continue;
                }
                if (n4 == 11) {
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    int[] nArray3 = new int[1];
                    int[] nArray4 = new int[1];
                    TJUnitTest.rgbToCMYK(n10, n11, n12, nArray, nArray2, nArray3, nArray4);
                    TJUnitTest.setVal(object, n9 * n2 + j * n8 + 0, nArray[0]);
                    TJUnitTest.setVal(object, n9 * n2 + j * n8 + 1, nArray2[0]);
                    TJUnitTest.setVal(object, n9 * n2 + j * n8 + 2, nArray3[0]);
                    TJUnitTest.setVal(object, n9 * n2 + j * n8 + 3, nArray4[0]);
                    continue;
                }
                TJUnitTest.setVal(object, n9 * n2 + j * n8 + n5, n10);
                TJUnitTest.setVal(object, n9 * n2 + j * n8 + n6, n11);
                TJUnitTest.setVal(object, n9 * n2 + j * n8 + n7, n12);
            }
        }
    }

    static void cmykToRGB(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int n5) {
        nArray[0] = (int)((double)n * (double)n4 / (double)n5 + 0.5);
        nArray2[0] = (int)((double)n2 * (double)n4 / (double)n5 + 0.5);
        nArray3[0] = (int)((double)n3 * (double)n4 / (double)n5 + 0.5);
    }

    static boolean cmpBitmap(Object object, int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5) {
        int n6 = TJ.getRedOffset(n4);
        int n7 = TJ.getGreenOffset(n4);
        int n8 = TJ.getBlueOffset(n4);
        int n9 = TJ.getAlphaOffset(n4);
        int n10 = TJ.getPixelSize(n4);
        int n11 = (1 << n5) - 1;
        for (int i = 0; i < n3; ++i) {
            int n12 = bl ? n3 - i - 1 : i;
            for (int j = 0; j < n; ++j) {
                int n13 = j * (maxSample + 1) / n % (maxSample + 1);
                int n14 = i * (maxSample + 1) / n3 % (maxSample + 1);
                int n15 = (i * (maxSample + 1) / n3 + j * (maxSample + 1) / n) % (maxSample + 1);
                if (precision != n5) {
                    long l = maxSample / 2;
                    n13 = (int)(((long)(n13 * ((1 << n5) - 1)) + l) / (long)maxSample);
                    n14 = (int)(((long)(n14 * ((1 << n5) - 1)) + l) / (long)maxSample);
                    n15 = (int)(((long)(n15 * ((1 << n5) - 1)) + l) / (long)maxSample);
                }
                if (n4 == 6) {
                    if (TJUnitTest.getVal(object, n12 * n2 + j * n10, n5) == n15) continue;
                    return false;
                }
                if (n4 == 11) {
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    int[] nArray3 = new int[1];
                    TJUnitTest.cmykToRGB(TJUnitTest.getVal(object, n12 * n2 + j * n10 + 0, n5), TJUnitTest.getVal(object, n12 * n2 + j * n10 + 1, n5), TJUnitTest.getVal(object, n12 * n2 + j * n10 + 2, n5), TJUnitTest.getVal(object, n12 * n2 + j * n10 + 3, n5), nArray, nArray2, nArray3, n11);
                    if (!(bl2 ? nArray[0] != n15 || nArray2[0] != n15 || nArray3[0] != n15 : nArray[0] != n13 || nArray2[0] != n14 || nArray3[0] != n15)) continue;
                    return false;
                }
                if (bl2 ? TJUnitTest.getVal(object, n12 * n2 + j * n10 + n6, n5) != n15 || TJUnitTest.getVal(object, n12 * n2 + j * n10 + n7, n5) != n15 || TJUnitTest.getVal(object, n12 * n2 + j * n10 + n8, n5) != n15 : TJUnitTest.getVal(object, n12 * n2 + j * n10 + n6, n5) != n13 || TJUnitTest.getVal(object, n12 * n2 + j * n10 + n7, n5) != n14 || TJUnitTest.getVal(object, n12 * n2 + j * n10 + n8, n5) != n15) {
                    return false;
                }
                if (n9 < 0 || TJUnitTest.getVal(object, n12 * n2 + j * n10 + n9, n5) == n11) continue;
                return false;
            }
        }
        return true;
    }

    static String getMD5Sum(String string) throws Exception {
        byte[] byArray = Files.readAllBytes(Paths.get(string, new String[0]));
        byte[] byArray2 = MessageDigest.getInstance("MD5").digest(byArray);
        return new BigInteger(1, byArray2).toString(16);
    }

    static void doBmpTest(String string, int n, int n2, int n3, int n4, boolean bl) throws Exception {
        TJCompressor tJCompressor = null;
        TJDecompressor tJDecompressor = null;
        int n5 = TJ.getPixelSize(n4);
        int n6 = TJUnitTest.pad(n * n5, n2);
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = n4;
        Object object = null;
        String[] stringArray = new String[]{"", "", "bad09d9ef38eda566848fb7c0b7fd0a", "7ef2c87261a8bd6838303b541563cf27", "28a37cf9636ff6bb9ed6b206bdac60db", "723307791d42e0b5f9e91625c7636086", "d729c4bcd3addc14abc16b656c6bbc98", "5d7636eedae3cf579b6de13078227548", "c0c9f772b464d1896326883a5c79c545", "fcf6490e0445569427f1d95baf5f8fcb", "5cbc3b0ccba23f5781d950a72e0ccc83", "d4e26d6d16d7bfee380f6feb10f7e53", "2ff5299287017502832c99718450c90a", "44ae6cd70c798ea583ab0c8c03621092", "697b2fe03892bc9a75396ad3e73d9203", "599732f973eb7c0849a888e783bbe27e", "623f54661b928d170bd2324bc3620565"};
        String[] stringArray2 = new String[]{"", "", "7565be35a2ce909cae016fa282af8efa", "e86b9ea57f7d53f6b5497653740992b5", "8924d4d81fe0220c684719294f93407a", "e2e69ba70efcfae317528c91651c7ae2", "e6154aafc1eb9e4333d68ce7ad9df051", "3d7fe831d6fbe55d3fa12f52059c15d3", "112c682e82ce5de1cca089e20d60000b", "5a7ce86c649dda86d6fed185ab78a67", "b723c0bc087592816523fbc906b7c3a", "5da422b1ddfd44c7659094d42ba5580c", "d1895c7e6f2b2c9af6e821a655c239c", "fc2803bca103ff75785ea0dca992aa", "d8c91fac522c16b029e514d331a22bc4", "e50cff0b3562ed7e64dbfc093440e333", "64f3320b226ea37fb58080713b4df1b2"};
        int n11 = 16;
        try {
            String string2;
            tJCompressor = new TJCompressor();
            tJCompressor.set(1, bl ? 1 : 0);
            tJDecompressor = new TJDecompressor();
            tJDecompressor.set(1, bl ? 1 : 0);
            tJDecompressor.set(7, precision);
            if (precision == 8 && string.equalsIgnoreCase("bmp")) {
                string2 = n4 == 6 ? "51976530acf75f02beddf5d21149101d" : "6d659071b9bfcdee2def22cb58ddadca";
                n11 = 8;
            } else {
                string2 = n4 == 6 ? stringArray2[precision] : stringArray[precision];
            }
            object = precision <= 8 ? new byte[n6 * n3] : (Object)new short[n6 * n3];
            TJUnitTest.initBitmap(object, n, n6, n3, n4, bl);
            String string3 = String.format("test_bmp%d_%s_%d_%s_%s.%s", precision, PIXFORMATSTR[n4], n2, bl ? "bu" : "td", uniqueID, string);
            tJDecompressor.saveImage(string3, object, 0, 0, n, n6, n3, n4);
            String string4 = TJUnitTest.getMD5Sum(string3);
            if (string4 == null) {
                throw new Exception("Could not determine MD5 sum of " + string3);
            }
            if (!string4.equalsIgnoreCase(string2)) {
                throw new Exception(string3 + " has an MD5 sum of " + string4 + ".  Should be " + string2);
            }
            for (int i = 2; i <= n11; ++i) {
                tJCompressor.set(7, i);
                n4 = n10;
                tJCompressor.loadSourceImage(string3, n2, n4);
                n7 = tJCompressor.getWidth();
                n8 = tJCompressor.getPitch();
                n9 = tJCompressor.getHeight();
                n4 = tJCompressor.getPixelFormat();
                object = tJCompressor.getSourceBuf();
                n6 = TJUnitTest.pad(n * TJ.getPixelSize(n4), n2);
                if (n != n7 || n6 != n8 || n3 != n9) {
                    throw new Exception("Image dimensions of " + string3 + " are bogus");
                }
                if (!TJUnitTest.cmpBitmap(object, n, n6, n3, n4, bl, false, string.equalsIgnoreCase("bmp") ? 8 : i)) {
                    throw new Exception("Pixel data in " + string3 + " is bogus (target data precision = " + i + ")");
                }
                if (n4 == 6) {
                    n4 = 4;
                    tJCompressor.loadSourceImage(string3, n2, n4);
                    n7 = tJCompressor.getWidth();
                    n8 = tJCompressor.getPitch();
                    n9 = tJCompressor.getHeight();
                    n4 = tJCompressor.getPixelFormat();
                    object = tJCompressor.getSourceBuf();
                    n6 = TJUnitTest.pad(n * TJ.getPixelSize(n4), n2);
                    if (n != n7 || n6 != n8 || n3 != n9) {
                        throw new Exception("Image dimensions of " + string3 + " are bogus");
                    }
                    if (!TJUnitTest.cmpBitmap(object, n, n6, n3, n4, bl, true, string.equalsIgnoreCase("bmp") ? 8 : i)) {
                        throw new Exception("Converting " + string3 + " to RGB failed (target data precision = " + i + ")");
                    }
                    n4 = 11;
                    tJCompressor.loadSourceImage(string3, n2, n4);
                    n7 = tJCompressor.getWidth();
                    n8 = tJCompressor.getPitch();
                    n9 = tJCompressor.getHeight();
                    n4 = tJCompressor.getPixelFormat();
                    object = tJCompressor.getSourceBuf();
                    n6 = TJUnitTest.pad(n * TJ.getPixelSize(n4), n2);
                    if (n != n7 || n6 != n8 || n3 != n9) {
                        throw new Exception("Image dimensions of " + string3 + " are bogus");
                    }
                    if (!TJUnitTest.cmpBitmap(object, n, n6, n3, n4, bl, true, string.equalsIgnoreCase("bmp") ? 8 : i)) {
                        throw new Exception("Converting " + string3 + " to CMYK failed (target data precision = " + i + ")");
                    }
                }
                n4 = n10;
                n10 = -1;
                tJCompressor.loadSourceImage(string3, n2, n10);
                n10 = tJCompressor.getPixelFormat();
                if (!(n4 == 6 && n10 != 6 || n4 != 6 && string.equalsIgnoreCase("bmp") && n10 != 1) && (n4 == 6 || !string.equalsIgnoreCase("ppm") || n10 == 0)) continue;
                throw new Exception("TJCompressor.loadImage() returned unexpected pixel format: " + PIXFORMATSTR[n10]);
            }
            File file = new File(string3);
            file.delete();
        }
        catch (Exception exception) {
            if (tJCompressor != null) {
                tJCompressor.close();
            }
            if (tJDecompressor != null) {
                tJDecompressor.close();
            }
            throw exception;
        }
        if (tJCompressor != null) {
            tJCompressor.close();
        }
        if (tJDecompressor != null) {
            tJDecompressor.close();
        }
    }

    static void bmpTest() throws Exception {
        int n = 35;
        int n2 = 39;
        for (int i = 1; i <= 8; i *= 2) {
            for (int j = 0; j < 12; ++j) {
                if (precision == 8) {
                    System.out.format("%s Top-Down BMP (row alignment = %d samples)  ...  ", PIXFORMATSTR[j], i);
                    TJUnitTest.doBmpTest("bmp", n, i, n2, j, false);
                    System.out.println("OK.");
                }
                System.out.format("%s Top-Down PPM (row alignment = %d samples)  ...  ", PIXFORMATSTR[j], i);
                TJUnitTest.doBmpTest("ppm", n, i, n2, j, true);
                System.out.println("OK.");
                if (precision == 8) {
                    System.out.format("%s Bottom-Up BMP (row alignment = %d samples)  ...  ", PIXFORMATSTR[j], i);
                    TJUnitTest.doBmpTest("bmp", n, i, n2, j, false);
                    System.out.println("OK.");
                }
                System.out.format("%s Bottom-Up PPM (row alignment = %d samples)  ...  ", PIXFORMATSTR[j], i);
                TJUnitTest.doBmpTest("ppm", n, i, n2, j, true);
                System.out.println("OK.");
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "javatest";
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-yuv")) {
                    doYUV = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-noyuvpad")) {
                    yuvAlign = 1;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-lossless")) {
                    lossless = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-bi")) {
                    bi = true;
                    string = "javabitest";
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-bmp")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-precision") && i < stringArray.length - 1) {
                    int n = -1;
                    try {
                        n = Integer.parseInt(stringArray[++i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n < 2 || n > 16) {
                        TJUnitTest.usage();
                    }
                    if ((precision = n) == 8 || precision == 12) continue;
                    lossless = true;
                    continue;
                }
                TJUnitTest.usage();
            }
            if (lossless && doYUV) {
                throw new Exception("Lossless JPEG and YUV encoding/decoding are incompatible.");
            }
            if (precision != 8 && doYUV) {
                throw new Exception("YUV encoding/decoding requires 8-bit data precision.");
            }
            if (precision != 8 && bi) {
                throw new Exception("BufferedImage support requires 8-bit data precision.");
            }
            System.out.format("Testing %d-bit precision\n", precision);
            sampleSize = precision <= 8 ? 1 : 2;
            maxSample = (1 << precision) - 1;
            tolerance = lossless ? 0 : (precision > 8 ? 2 : 1);
            redToY = 19595 * maxSample >> 16;
            yellowToY = 58065 * maxSample >> 16;
            if (bl) {
                TJUnitTest.bmpTest();
                System.exit(exitStatus);
            }
            if (doYUV) {
                TJUnitTest.FORMATS_4SAMPLE[4] = -1;
            }
            TJUnitTest.overflowTest();
            TJUnitTest.doTest(35, 39, bi ? FORMATS_3BYTEBI : FORMATS_3SAMPLE, 0, string);
            TJUnitTest.doTest(39, 41, bi ? FORMATS_4BYTEBI : FORMATS_4SAMPLE, 0, string);
            TJUnitTest.doTest(41, 35, bi ? FORMATS_3BYTEBI : FORMATS_3SAMPLE, 1, string);
            if (!lossless) {
                TJUnitTest.doTest(35, 39, bi ? FORMATS_4BYTEBI : FORMATS_4SAMPLE, 1, string);
                TJUnitTest.doTest(39, 41, bi ? FORMATS_3BYTEBI : FORMATS_3SAMPLE, 2, string);
                TJUnitTest.doTest(41, 35, bi ? FORMATS_4BYTEBI : FORMATS_4SAMPLE, 2, string);
                TJUnitTest.doTest(35, 39, bi ? FORMATS_3BYTEBI : FORMATS_3SAMPLE, 4, string);
                TJUnitTest.doTest(39, 41, bi ? FORMATS_4BYTEBI : FORMATS_4SAMPLE, 4, string);
                TJUnitTest.doTest(41, 35, bi ? FORMATS_3BYTEBI : FORMATS_3SAMPLE, 5, string);
                TJUnitTest.doTest(35, 39, bi ? FORMATS_4BYTEBI : FORMATS_4SAMPLE, 5, string);
                TJUnitTest.doTest(39, 41, bi ? FORMATS_3BYTEBI : FORMATS_3SAMPLE, 6, string);
                TJUnitTest.doTest(41, 35, bi ? FORMATS_4BYTEBI : FORMATS_4SAMPLE, 6, string);
            }
            TJUnitTest.doTest(39, 41, bi ? FORMATS_GRAYBI : FORMATS_GRAY, 3, string);
            if (!lossless) {
                TJUnitTest.doTest(41, 35, bi ? FORMATS_3BYTEBI : FORMATS_3SAMPLE, 3, string);
                TJUnitTest.FORMATS_4SAMPLE[4] = -1;
                TJUnitTest.doTest(35, 39, bi ? FORMATS_4BYTEBI : FORMATS_4SAMPLE, 3, string);
            }
            if (!bi) {
                TJUnitTest.bufSizeTest();
            }
            if (doYUV && !bi) {
                System.out.print("\n--------------------\n\n");
                TJUnitTest.doTest(48, 48, FORMATS_RGB, 0, "javatest_yuv0");
                TJUnitTest.doTest(48, 48, FORMATS_RGB, 1, "javatest_yuv0");
                TJUnitTest.doTest(48, 48, FORMATS_RGB, 2, "javatest_yuv0");
                TJUnitTest.doTest(48, 48, FORMATS_RGB, 4, "javatest_yuv0");
                TJUnitTest.doTest(48, 48, FORMATS_RGB, 5, "javatest_yuv0");
                TJUnitTest.doTest(48, 48, FORMATS_RGB, 6, "javatest_yuv0");
                TJUnitTest.doTest(48, 48, FORMATS_RGB, 3, "javatest_yuv0");
                TJUnitTest.doTest(48, 48, FORMATS_GRAY, 3, "javatest_yuv0");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            exitStatus = -1;
        }
        System.exit(exitStatus);
    }

    static {
        bi = false;
        exitStatus = 0;
        uniqueID = UUID.randomUUID().toString().replace("-", "");
    }
}

