/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.seqno;

import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002 !B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001e\u001a\u00020\u001fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001a\u0010\u0018\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR\u001a\u0010\u001b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0006\"\u0004\b\u001d\u0010\b\u00a8\u0006\""}, d2={"Lorg/opensearch/replication/seqno/RemoteShardMetric;", "", "()V", "bytesRead", "Ljava/util/concurrent/atomic/AtomicLong;", "getBytesRead", "()Ljava/util/concurrent/atomic/AtomicLong;", "setBytesRead", "(Ljava/util/concurrent/atomic/AtomicLong;)V", "lastFetchTime", "getLastFetchTime", "setLastFetchTime", "latencyLucene", "getLatencyLucene", "setLatencyLucene", "latencyTlog", "getLatencyTlog", "setLatencyTlog", "ops", "getOps", "setOps", "opsLucene", "getOpsLucene", "setOpsLucene", "opsTlog", "getOpsTlog", "setOpsTlog", "tlogSize", "getTlogSize", "setTlogSize", "createStats", "Lorg/opensearch/replication/seqno/RemoteShardMetric$RemoteStats;", "RemoteStats", "RemoteStatsFrag", "opensearch-cross-cluster-replication"})
public final class RemoteShardMetric {
    @NotNull
    private AtomicLong ops = new AtomicLong();
    @NotNull
    private AtomicLong tlogSize = new AtomicLong();
    @NotNull
    private AtomicLong opsLucene = new AtomicLong();
    @NotNull
    private AtomicLong opsTlog = new AtomicLong();
    @NotNull
    private AtomicLong latencyLucene = new AtomicLong();
    @NotNull
    private AtomicLong latencyTlog = new AtomicLong();
    @NotNull
    private AtomicLong bytesRead = new AtomicLong();
    @NotNull
    private AtomicLong lastFetchTime = new AtomicLong();

    @NotNull
    public final AtomicLong getOps() {
        return this.ops;
    }

    public final void setOps(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.ops = atomicLong;
    }

    @NotNull
    public final AtomicLong getTlogSize() {
        return this.tlogSize;
    }

    public final void setTlogSize(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.tlogSize = atomicLong;
    }

    @NotNull
    public final AtomicLong getOpsLucene() {
        return this.opsLucene;
    }

    public final void setOpsLucene(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.opsLucene = atomicLong;
    }

    @NotNull
    public final AtomicLong getOpsTlog() {
        return this.opsTlog;
    }

    public final void setOpsTlog(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.opsTlog = atomicLong;
    }

    @NotNull
    public final AtomicLong getLatencyLucene() {
        return this.latencyLucene;
    }

    public final void setLatencyLucene(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.latencyLucene = atomicLong;
    }

    @NotNull
    public final AtomicLong getLatencyTlog() {
        return this.latencyTlog;
    }

    public final void setLatencyTlog(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.latencyTlog = atomicLong;
    }

    @NotNull
    public final AtomicLong getBytesRead() {
        return this.bytesRead;
    }

    public final void setBytesRead(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.bytesRead = atomicLong;
    }

    @NotNull
    public final AtomicLong getLastFetchTime() {
        return this.lastFetchTime;
    }

    public final void setLastFetchTime(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.lastFetchTime = atomicLong;
    }

    @NotNull
    public final RemoteStats createStats() {
        return new RemoteStats(this.ops.get(), this.tlogSize.get(), this.opsLucene.get(), this.opsTlog.get(), this.latencyLucene.get(), this.latencyTlog.get(), this.bytesRead.get(), this.lastFetchTime.get());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BU\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\f\u001a\u00020\u0006\u0012\b\b\u0002\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0000J\u001a\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0018\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\b\u0010&\u001a\u0004\u0018\u00010'J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,R\u001a\u0010\f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\r\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0010\"\u0004\b\u001a\u0010\u0012R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0010\"\u0004\b\u001c\u0010\u0012R\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0010\"\u0004\b\u001e\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010\u0012\u00a8\u0006-"}, d2={"Lorg/opensearch/replication/seqno/RemoteShardMetric$RemoteStats;", "Lorg/opensearch/core/xcontent/ToXContentFragment;", "inp", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "ops", "", "tlogSize", "opsLucene", "opsTlog", "latencyLucene", "latencyTlog", "bytesRead", "lastFetchTime", "(JJJJJJJJ)V", "getBytesRead", "()J", "setBytesRead", "(J)V", "getLastFetchTime", "setLastFetchTime", "getLatencyLucene", "setLatencyLucene", "getLatencyTlog", "setLatencyTlog", "getOps", "setOps", "getOpsLucene", "setOpsLucene", "getOpsTlog", "setOpsTlog", "getTlogSize", "setTlogSize", "add", "stat", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "toXContentFragment", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "opensearch-cross-cluster-replication"})
    public static class RemoteStats
    implements ToXContentFragment {
        private long ops;
        private long tlogSize;
        private long opsLucene;
        private long opsTlog;
        private long latencyLucene;
        private long latencyTlog;
        private long bytesRead;
        private long lastFetchTime;

        public RemoteStats(long ops, long tlogSize, long opsLucene, long opsTlog, long latencyLucene, long latencyTlog, long bytesRead, long lastFetchTime) {
            this.ops = ops;
            this.tlogSize = tlogSize;
            this.opsLucene = opsLucene;
            this.opsTlog = opsTlog;
            this.latencyLucene = latencyLucene;
            this.latencyTlog = latencyTlog;
            this.bytesRead = bytesRead;
            this.lastFetchTime = lastFetchTime;
        }

        public /* synthetic */ RemoteStats(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            if ((n & 4) != 0) {
                l3 = 0L;
            }
            if ((n & 8) != 0) {
                l4 = 0L;
            }
            if ((n & 0x10) != 0) {
                l5 = 0L;
            }
            if ((n & 0x20) != 0) {
                l6 = 0L;
            }
            if ((n & 0x40) != 0) {
                l7 = 0L;
            }
            if ((n & 0x80) != 0) {
                l8 = 0L;
            }
            this(l, l2, l3, l4, l5, l6, l7, l8);
        }

        public final long getOps() {
            return this.ops;
        }

        public final void setOps(long l) {
            this.ops = l;
        }

        public final long getTlogSize() {
            return this.tlogSize;
        }

        public final void setTlogSize(long l) {
            this.tlogSize = l;
        }

        public final long getOpsLucene() {
            return this.opsLucene;
        }

        public final void setOpsLucene(long l) {
            this.opsLucene = l;
        }

        public final long getOpsTlog() {
            return this.opsTlog;
        }

        public final void setOpsTlog(long l) {
            this.opsTlog = l;
        }

        public final long getLatencyLucene() {
            return this.latencyLucene;
        }

        public final void setLatencyLucene(long l) {
            this.latencyLucene = l;
        }

        public final long getLatencyTlog() {
            return this.latencyTlog;
        }

        public final void setLatencyTlog(long l) {
            this.latencyTlog = l;
        }

        public final long getBytesRead() {
            return this.bytesRead;
        }

        public final void setBytesRead(long l) {
            this.bytesRead = l;
        }

        public final long getLastFetchTime() {
            return this.lastFetchTime;
        }

        public final void setLastFetchTime(long l) {
            this.lastFetchTime = l;
        }

        @NotNull
        public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            builder.startObject();
            this.toXContentFragment(builder, params);
            XContentBuilder xContentBuilder = builder.endObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
            return xContentBuilder;
        }

        @NotNull
        public final XContentBuilder toXContentFragment(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            builder.field("operations_read", this.ops);
            builder.field("translog_size_bytes", this.tlogSize);
            builder.field("operations_read_lucene", this.opsLucene);
            builder.field("operations_read_translog", this.opsTlog);
            builder.field("total_read_time_lucene_millis", this.latencyLucene);
            builder.field("total_read_time_translog_millis", this.latencyTlog);
            builder.field("bytes_read", this.bytesRead);
            return builder;
        }

        public RemoteStats(@NotNull StreamInput inp) {
            Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
            this(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 255, null);
            this.ops = inp.readLong();
            this.tlogSize = inp.readLong();
            this.opsLucene = inp.readLong();
            this.opsTlog = inp.readLong();
            this.latencyLucene = inp.readLong();
            this.latencyTlog = inp.readLong();
            this.bytesRead = inp.readLong();
            this.lastFetchTime = inp.readLong();
        }

        public final void writeTo(@NotNull StreamOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeLong(this.ops);
            out.writeLong(this.tlogSize);
            out.writeLong(this.opsLucene);
            out.writeLong(this.opsTlog);
            out.writeLong(this.latencyLucene);
            out.writeLong(this.latencyTlog);
            out.writeLong(this.bytesRead);
            out.writeLong(this.lastFetchTime);
        }

        @NotNull
        public final RemoteStats add(@NotNull RemoteStats stat) {
            RemoteStats newStat;
            Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
            RemoteStats remoteStats = newStat = this;
            remoteStats.ops += stat.ops;
            remoteStats = newStat;
            remoteStats.tlogSize += stat.tlogSize;
            remoteStats = newStat;
            remoteStats.opsLucene += stat.opsLucene;
            remoteStats = newStat;
            remoteStats.opsTlog += stat.opsTlog;
            remoteStats = newStat;
            remoteStats.latencyLucene += stat.latencyLucene;
            remoteStats = newStat;
            remoteStats.latencyTlog += stat.latencyTlog;
            remoteStats = newStat;
            remoteStats.bytesRead += stat.bytesRead;
            newStat.lastFetchTime = Math.max(this.lastFetchTime, stat.lastFetchTime);
            return newStat;
        }

        public RemoteStats() {
            this(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 255, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/opensearch/replication/seqno/RemoteShardMetric$RemoteStatsFrag;", "Lorg/opensearch/replication/seqno/RemoteShardMetric$RemoteStats;", "Lorg/opensearch/core/xcontent/ToXContentFragment;", "()V", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "opensearch-cross-cluster-replication"})
    public static final class RemoteStatsFrag
    extends RemoteStats
    implements ToXContentFragment {
        public RemoteStatsFrag() {
            super(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 255, null);
        }

        @Override
        @NotNull
        public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            return this.toXContentFragment(builder, params);
        }
    }
}

