/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.ManagedBy;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DataStreamIndex
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, DataStreamIndex> {
    @Nullable
    private final String ilmPolicy;
    @Nonnull
    private final String indexName;
    @Nonnull
    private final String indexUuid;
    @Nullable
    private final ManagedBy managedBy;
    @Nullable
    private final Boolean preferIlm;
    public static final JsonpDeserializer<DataStreamIndex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamIndex::setupDataStreamIndexDeserializer);

    private DataStreamIndex(Builder builder) {
        this.ilmPolicy = builder.ilmPolicy;
        this.indexName = ApiTypeHelper.requireNonNull(builder.indexName, this, "indexName");
        this.indexUuid = ApiTypeHelper.requireNonNull(builder.indexUuid, this, "indexUuid");
        this.managedBy = builder.managedBy;
        this.preferIlm = builder.preferIlm;
    }

    public static DataStreamIndex of(Function<Builder, ObjectBuilder<DataStreamIndex>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String ilmPolicy() {
        return this.ilmPolicy;
    }

    @Nonnull
    public final String indexName() {
        return this.indexName;
    }

    @Nonnull
    public final String indexUuid() {
        return this.indexUuid;
    }

    @Nullable
    public final ManagedBy managedBy() {
        return this.managedBy;
    }

    @Nullable
    public final Boolean preferIlm() {
        return this.preferIlm;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.ilmPolicy != null) {
            generator.writeKey("ilm_policy");
            generator.write(this.ilmPolicy);
        }
        generator.writeKey("index_name");
        generator.write(this.indexName);
        generator.writeKey("index_uuid");
        generator.write(this.indexUuid);
        if (this.managedBy != null) {
            generator.writeKey("managed_by");
            this.managedBy.serialize(generator, mapper);
        }
        if (this.preferIlm != null) {
            generator.writeKey("prefer_ilm");
            generator.write(this.preferIlm.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDataStreamIndexDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::ilmPolicy, JsonpDeserializer.stringDeserializer(), "ilm_policy");
        op.add(Builder::indexName, JsonpDeserializer.stringDeserializer(), "index_name");
        op.add(Builder::indexUuid, JsonpDeserializer.stringDeserializer(), "index_uuid");
        op.add(Builder::managedBy, ManagedBy._DESERIALIZER, "managed_by");
        op.add(Builder::preferIlm, JsonpDeserializer.booleanDeserializer(), "prefer_ilm");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.ilmPolicy);
        result = 31 * result + this.indexName.hashCode();
        result = 31 * result + this.indexUuid.hashCode();
        result = 31 * result + Objects.hashCode(this.managedBy);
        result = 31 * result + Objects.hashCode(this.preferIlm);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStreamIndex other = (DataStreamIndex)o;
        return Objects.equals(this.ilmPolicy, other.ilmPolicy) && this.indexName.equals(other.indexName) && this.indexUuid.equals(other.indexUuid) && Objects.equals(this.managedBy, other.managedBy) && Objects.equals(this.preferIlm, other.preferIlm);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, DataStreamIndex> {
        @Nullable
        private String ilmPolicy;
        private String indexName;
        private String indexUuid;
        @Nullable
        private ManagedBy managedBy;
        @Nullable
        private Boolean preferIlm;

        public Builder() {
        }

        private Builder(DataStreamIndex o) {
            this.ilmPolicy = o.ilmPolicy;
            this.indexName = o.indexName;
            this.indexUuid = o.indexUuid;
            this.managedBy = o.managedBy;
            this.preferIlm = o.preferIlm;
        }

        private Builder(Builder o) {
            this.ilmPolicy = o.ilmPolicy;
            this.indexName = o.indexName;
            this.indexUuid = o.indexUuid;
            this.managedBy = o.managedBy;
            this.preferIlm = o.preferIlm;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder ilmPolicy(@Nullable String value) {
            this.ilmPolicy = value;
            return this;
        }

        @Nonnull
        public final Builder indexName(String value) {
            this.indexName = value;
            return this;
        }

        @Nonnull
        public final Builder indexUuid(String value) {
            this.indexUuid = value;
            return this;
        }

        @Nonnull
        public final Builder managedBy(@Nullable ManagedBy value) {
            this.managedBy = value;
            return this;
        }

        @Nonnull
        public final Builder preferIlm(@Nullable Boolean value) {
            this.preferIlm = value;
            return this;
        }

        @Override
        @Nonnull
        public DataStreamIndex build() {
            this._checkSingleUse();
            return new DataStreamIndex(this);
        }
    }
}

