/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.internal.auth;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.profiles.Profile;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.utils.Lazy;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class Sigv4aSigningRegionSetProvider {
    private final Supplier<ProfileFile> profileFile;
    private final String profileName;
    private final Lazy<Set<String>> regionSet;

    private Sigv4aSigningRegionSetProvider(Builder builder) {
        this.profileFile = (Supplier)Validate.paramNotNull((Object)builder.profileFile, (String)"profileFile");
        this.profileName = builder.profileName;
        this.regionSet = new Lazy(this::regionSet);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<String> resolveRegionSet() {
        return (Set)this.regionSet.getValue();
    }

    private Set<String> regionSet() {
        Optional property;
        Optional setting = SdkSystemSetting.AWS_SIGV4A_SIGNING_REGION_SET.getStringValue();
        if (setting.isPresent()) {
            return this.parseRegionSet((String)setting.get());
        }
        ProfileFile file = this.profileFile.get();
        Optional profile = file.profile(this.profileName());
        if (profile.isPresent() && (property = ((Profile)profile.get()).property("sigv4a_signing_region_set")).isPresent()) {
            return this.parseRegionSet((String)property.get());
        }
        return Collections.emptySet();
    }

    private Set<String> parseRegionSet(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Collections.emptySet();
        }
        return Arrays.stream(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    private String profileName() {
        return this.profileName != null ? this.profileName : ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow();
    }

    public static final class Builder {
        private Supplier<ProfileFile> profileFile = ProfileFile::defaultProfileFile;
        private String profileName;

        private Builder() {
        }

        public Builder profileFile(Supplier<ProfileFile> profileFile) {
            this.profileFile = profileFile;
            return this;
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public Sigv4aSigningRegionSetProvider build() {
            return new Sigv4aSigningRegionSetProvider(this);
        }
    }
}

