/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ism;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ism.ExplainPolicy;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ExplainPolicyResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ExplainPolicyResponse> {
    @Nonnull
    private final Map<String, ExplainPolicy> metadata;
    @Nullable
    private final Number totalManagedIndices;
    public static final JsonpDeserializer<ExplainPolicyResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExplainPolicyResponse::setupExplainPolicyResponseDeserializer);

    private ExplainPolicyResponse(Builder builder) {
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.totalManagedIndices = builder.totalManagedIndices;
    }

    public static ExplainPolicyResponse of(Function<Builder, ObjectBuilder<ExplainPolicyResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, ExplainPolicy> metadata() {
        return this.metadata;
    }

    @Nullable
    public final Number totalManagedIndices() {
        return this.totalManagedIndices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, ExplainPolicy> item0 : this.metadata.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        if (this.totalManagedIndices != null) {
            generator.writeKey("total_managed_indices");
            generator.write(this.totalManagedIndices.doubleValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupExplainPolicyResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::totalManagedIndices, JsonpDeserializer.numberDeserializer(), "total_managed_indices");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (((Builder)builder).metadata == null) {
                ((Builder)builder).metadata = new HashMap();
            }
            ((Builder)builder).metadata.put(name, ExplainPolicy._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.metadata);
        result = 31 * result + Objects.hashCode(this.totalManagedIndices);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExplainPolicyResponse other = (ExplainPolicyResponse)o;
        return Objects.equals(this.metadata, other.metadata) && Objects.equals(this.totalManagedIndices, other.totalManagedIndices);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ExplainPolicyResponse> {
        @Nullable
        private Map<String, ExplainPolicy> metadata;
        @Nullable
        private Number totalManagedIndices;

        public Builder() {
        }

        private Builder(ExplainPolicyResponse o) {
            this.metadata = Builder._mapCopy(o.metadata);
            this.totalManagedIndices = o.totalManagedIndices;
        }

        private Builder(Builder o) {
            this.metadata = Builder._mapCopy(o.metadata);
            this.totalManagedIndices = o.totalManagedIndices;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder metadata(Map<String, ExplainPolicy> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        @Nonnull
        public final Builder metadata(String key, ExplainPolicy value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        @Nonnull
        public final Builder metadata(String key, Function<ExplainPolicy.Builder, ObjectBuilder<ExplainPolicy>> fn) {
            return this.metadata(key, fn.apply(new ExplainPolicy.Builder()).build());
        }

        @Nonnull
        public final Builder totalManagedIndices(@Nullable Number value) {
            this.totalManagedIndices = value;
            return this;
        }

        @Override
        @Nonnull
        public ExplainPolicyResponse build() {
            this._checkSingleUse();
            return new ExplainPolicyResponse(this);
        }
    }
}

