/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.regexp;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.codeInsight.PyInjectionUtil;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.regexp.PythonRegexpLanguage;
import com.jetbrains.python.codeInsight.regexp.PythonVerboseRegexpLanguage;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonRegexpInjector
implements MultiHostInjector {
    private final List<RegexpMethodDescriptor> myDescriptors = new ArrayList<RegexpMethodDescriptor>();

    public PythonRegexpInjector() {
        this.addMethod("compile");
        this.addMethod("search");
        this.addMethod("match");
        this.addMethod("fullmatch");
        this.addMethod("split");
        this.addMethod("splititer");
        this.addMethod("findall");
        this.addMethod("finditer");
        this.addMethod("sub");
        this.addMethod("subf");
        this.addMethod("subn");
        this.addMethod("subfn");
        this.addMethod("template");
    }

    private void addMethod(@NotNull String name2) {
        if (name2 == null) {
            PythonRegexpInjector.$$$reportNull$$$0(0);
        }
        this.myDescriptors.add(new RegexpMethodDescriptor(name2, 0));
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        RegexpMethodDescriptor methodDescriptor;
        PyCallExpression call;
        if (registrar == null) {
            PythonRegexpInjector.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PythonRegexpInjector.$$$reportNull$$$0(2);
        }
        PyArgumentList argumentList = (PyArgumentList)PyUtil.as((Object)context.getParent(), PyArgumentList.class);
        if (PyInjectionUtil.getLargestStringLiteral(context) == context && argumentList != null && (call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PyCallExpression.class)) != null && (methodDescriptor = this.findRegexpMethodDescriptor(this.resolvePossibleRegexpCall(call))) != null && methodDescriptor.argIndex == ArrayUtil.indexOf((Object[])argumentList.getArguments(), (Object)context)) {
            PythonRegexpInjector.injectRegexpLanguage(registrar, context, PythonRegexpInjector.isVerbose(call));
        }
    }

    @Nullable
    private PsiElement resolvePossibleRegexpCall(@NotNull PyCallExpression call) {
        PyExpression callee;
        if (call == null) {
            PythonRegexpInjector.$$$reportNull$$$0(3);
        }
        if ((callee = call.getCallee()) instanceof PyReferenceExpression) {
            PyReferenceExpression referenceExpression = (PyReferenceExpression)callee;
            if (this.canBeRegexpCall(callee)) {
                TypeEvalContext context = TypeEvalContext.codeAnalysis((Project)call.getProject(), (PsiFile)call.getContainingFile());
                return referenceExpression.getReference(PyResolveContext.defaultContext((TypeEvalContext)context)).resolve();
            }
        }
        return null;
    }

    private static void injectRegexpLanguage(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context, boolean verbose) {
        if (registrar == null) {
            PythonRegexpInjector.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PythonRegexpInjector.$$$reportNull$$$0(5);
        }
        Language language = verbose ? PythonVerboseRegexpLanguage.INSTANCE : PythonRegexpLanguage.INSTANCE;
        PyInjectionUtil.registerStringLiteralInjection(context, registrar, language);
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(PyStringLiteralExpression.class, PyParenthesizedExpression.class, PyBinaryExpression.class, PyCallExpression.class);
        if (list == null) {
            PythonRegexpInjector.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean isVerbose(@NotNull PyCallExpression call) {
        PyExpression[] arguments;
        if (call == null) {
            PythonRegexpInjector.$$$reportNull$$$0(7);
        }
        return (arguments = call.getArguments()).length > 1 && PythonRegexpInjector.isVerbose(arguments[arguments.length - 1]);
    }

    private static boolean isVerbose(@Nullable PyExpression expression) {
        if (expression instanceof PyKeywordArgument) {
            PyKeywordArgument keywordArgument = (PyKeywordArgument)expression;
            return "flags".equals(keywordArgument.getName()) && PythonRegexpInjector.isVerbose(keywordArgument.getValueExpression());
        }
        if (expression instanceof PyReferenceExpression) {
            String flagName = ((PyReferenceExpression)expression).getReferencedName();
            return "VERBOSE".equals(flagName) || "X".equals(flagName);
        }
        if (expression instanceof PyBinaryExpression) {
            PyBinaryExpression binaryExpression = (PyBinaryExpression)expression;
            return PythonRegexpInjector.isVerbose(binaryExpression.getLeftExpression()) || PythonRegexpInjector.isVerbose(binaryExpression.getRightExpression());
        }
        return false;
    }

    @Nullable
    private RegexpMethodDescriptor findRegexpMethodDescriptor(@Nullable PsiElement element) {
        if (element == null || !(ScopeUtil.getScopeOwner((PsiElement)element) instanceof PyFile) || !(element instanceof PyFunction)) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        String fileName = containingFile.getName();
        if (!ArrayUtil.contains((String)fileName, (String[])new String[]{"re.py", "re.pyi"})) {
            String moduleName;
            QualifiedName qName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)containingFile, null);
            String string = moduleName = qName != null ? qName.toString() : null;
            if (!"regex._main".equals(moduleName)) {
                return null;
            }
        }
        String functionName = ((PyFunction)element).getName();
        return this.myDescriptors.stream().filter(descriptor -> descriptor.methodName.equals(functionName)).findAny().orElse(null);
    }

    private boolean canBeRegexpCall(@NotNull PyExpression callee) {
        if (callee == null) {
            PythonRegexpInjector.$$$reportNull$$$0(8);
        }
        String text = callee.getText();
        return this.myDescriptors.stream().anyMatch(descriptor -> text.endsWith(descriptor.methodName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/regexp/PythonRegexpInjector";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callee";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/regexp/PythonRegexpInjector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addMethod";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolvePossibleRegexpCall";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "injectRegexpLanguage";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isVerbose";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canBeRegexpCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private static final class RegexpMethodDescriptor {
        @NotNull
        private final String methodName;
        private final int argIndex;

        private RegexpMethodDescriptor(@NotNull String methodName, int argIndex) {
            if (methodName == null) {
                RegexpMethodDescriptor.$$$reportNull$$$0(0);
            }
            this.methodName = methodName;
            this.argIndex = argIndex;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/jetbrains/python/codeInsight/regexp/PythonRegexpInjector$RegexpMethodDescriptor", "<init>"));
        }
    }
}

