/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleOption;
import org.languagetool.rules.TextLevelRule;

public abstract class AbstractStyleTooOftenUsedWordRule
extends TextLevelRule {
    private static final Pattern OPENING_QUOTES = Pattern.compile("[\"\u201c\u201e\u00bb\u00ab]");
    private static final Pattern ENDING_QUOTES = Pattern.compile("[\"\u201c\u201d\u00bb\u00ab]");
    private static final boolean DEFAULT_ACTIVATION = false;
    private static final int MIN_WORD_COUNT = 100;
    private final int minPercent;
    private final int defaultMinPercent;
    private final Map<String, Integer> wordMap = new HashMap<String, Integer>();
    private boolean withoutDirectSpeech = false;

    public AbstractStyleTooOftenUsedWordRule(ResourceBundle messages, Language lang, UserConfig userConfig, int minPercent) {
        this(messages, lang, userConfig, minPercent, false);
    }

    public AbstractStyleTooOftenUsedWordRule(ResourceBundle messages, Language lang, UserConfig userConfig, int minPercent, boolean defaultActive) {
        super(messages);
        super.setCategory(new Category(new CategoryId("CREATIVE_WRITING"), messages.getString("category_creative_writing"), Category.Location.INTERNAL, false));
        if (!defaultActive) {
            this.setDefaultOff();
        }
        this.defaultMinPercent = minPercent;
        this.minPercent = this.getMinPercent(userConfig, minPercent);
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    protected abstract boolean isToCountedWord(AnalyzedTokenReadings var1);

    protected abstract boolean isException(AnalyzedTokenReadings[] var1, int var2);

    protected abstract String toAddedLemma(AnalyzedTokenReadings var1);

    protected abstract String getLimitMessage(int var1);

    public abstract String getConfigureText();

    private int getMinPercent(UserConfig userConfig, int minPercentDefault) {
        Object[] cf;
        if (userConfig != null && (cf = userConfig.getConfigValueByID(this.getId())) != null) {
            return (Integer)cf[0];
        }
        return minPercentDefault;
    }

    @Override
    public RuleOption[] getRuleOptions() {
        RuleOption[] ruleOptions = new RuleOption[]{new RuleOption(this.defaultMinPercent, this.getConfigureText(), 1, 100)};
        return ruleOptions;
    }

    public Map<String, Integer> getWordMap() {
        return this.wordMap;
    }

    public void setWithoutDirectSpeech(boolean withoutDirectSpeech) {
        this.withoutDirectSpeech = withoutDirectSpeech;
    }

    private void FillWordMap(List<AnalyzedSentence> sentences) {
        this.wordMap.clear();
        boolean excludeDirectSpeech = this.withoutDirectSpeech;
        boolean isDirectSpeech = false;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
            for (int n = 1; n < tokens.length; ++n) {
                String lemma;
                AnalyzedTokenReadings token = tokens[n];
                String sToken = token.getToken();
                if (excludeDirectSpeech && !isDirectSpeech && OPENING_QUOTES.matcher(sToken).matches() && n < tokens.length - 1 && !tokens[n + 1].isWhitespaceBefore()) {
                    isDirectSpeech = true;
                    continue;
                }
                if (excludeDirectSpeech && isDirectSpeech && ENDING_QUOTES.matcher(sToken).matches() && n > 1 && !tokens[n].isWhitespaceBefore()) {
                    isDirectSpeech = false;
                    continue;
                }
                if (isDirectSpeech || token.isWhitespace() || token.isNonWord() || !this.isToCountedWord(token) || this.isException(tokens, n) || (lemma = this.toAddedLemma(token)) == null) continue;
                if (this.wordMap.containsKey(lemma)) {
                    int num = this.wordMap.get(lemma) + 1;
                    this.wordMap.put(lemma, num);
                    continue;
                }
                this.wordMap.put(lemma, 1);
            }
        }
    }

    private List<String> getTooOftenUsedWords() {
        ArrayList<String> words = new ArrayList<String>();
        int numWords = 0;
        for (String word : this.wordMap.keySet()) {
            numWords += this.wordMap.get(word).intValue();
        }
        if (numWords < 100) {
            return words;
        }
        for (String word : this.wordMap.keySet()) {
            int percent = (int)((double)this.wordMap.get(word).intValue() * 100.0 / (double)numWords);
            if (percent < this.minPercent) continue;
            words.add(word);
        }
        return words;
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        this.FillWordMap(sentences);
        List<String> tooOftenUsedWords = this.getTooOftenUsedWords();
        if (tooOftenUsedWords.size() < 1) {
            return this.toRuleMatchArray(ruleMatches);
        }
        int pos = 0;
        boolean excludeDirectSpeech = this.withoutDirectSpeech;
        boolean isDirectSpeech = false;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
            block1: for (int n = 1; n < tokens.length; ++n) {
                String lemma;
                AnalyzedTokenReadings token = tokens[n];
                String sToken = token.getToken();
                if (excludeDirectSpeech && !isDirectSpeech && OPENING_QUOTES.matcher(sToken).matches() && n < tokens.length - 1 && !tokens[n + 1].isWhitespaceBefore()) {
                    isDirectSpeech = true;
                    continue;
                }
                if (excludeDirectSpeech && isDirectSpeech && ENDING_QUOTES.matcher(sToken).matches() && n > 1 && !tokens[n].isWhitespaceBefore()) {
                    isDirectSpeech = false;
                    continue;
                }
                if (isDirectSpeech || token.isWhitespace() || token.isNonWord() || !this.isToCountedWord(token) || this.isException(tokens, n) || (lemma = this.toAddedLemma(token)) == null) continue;
                for (String word : tooOftenUsedWords) {
                    if (!lemma.equals(word)) continue;
                    RuleMatch ruleMatch = new RuleMatch(this, sentence, token.getStartPos() + pos, token.getEndPos() + pos, this.getLimitMessage(this.minPercent));
                    ruleMatches.add(ruleMatch);
                    continue block1;
                }
            }
            pos += sentence.getCorrectedTextLength();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return -1;
    }

    protected String getLemmaForPosTagStartsWith(String startPos, AnalyzedTokenReadings token) {
        List<AnalyzedToken> readings = token.getReadings();
        for (AnalyzedToken reading : readings) {
            String posTag = reading.getPOSTag();
            if (posTag == null || !posTag.startsWith(startPos)) continue;
            return reading.getLemma();
        }
        return null;
    }
}

