/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Stack;
import org.freehep.graphicsio.QuadToCubicPathConstructor;

public abstract class CubicToLinePathConstructor
extends QuadToCubicPathConstructor {
    private double resolution;

    protected CubicToLinePathConstructor() {
        this(0.025);
    }

    protected CubicToLinePathConstructor(double resolution) {
        this.resolution = Math.abs(resolution);
    }

    public void cubic(double x1, double y1, double x2, double y2, double x3, double y3) throws IOException {
        Stack<ControlSet> controls = new Stack<ControlSet>();
        Point2D.Double p0 = new Point2D.Double(this.currentX, this.currentY);
        Point2D.Double p1 = new Point2D.Double(x1, y1);
        Point2D.Double p2 = new Point2D.Double(x2, y2);
        Point2D.Double p3 = new Point2D.Double(x3, y3);
        Stack<ControlSet> temps = new Stack<ControlSet>();
        temps.push(new ControlSet(p0, p1, p2, p3));
        while (!temps.empty()) {
            ControlSet control = (ControlSet)temps.pop();
            if (control.breadth() > this.resolution) {
                temps.push(control);
                temps.push(control.bisect());
                continue;
            }
            controls.push(control);
        }
        while (!controls.empty()) {
            Point2D p = ((ControlSet)controls.pop()).getPoint();
            this.line(p.getX(), p.getY());
        }
        super.cubic(x1, y1, x2, y2, x3, y3);
    }

    class ControlSet {
        private Point2D point0;
        private Point2D point1;
        private Point2D point2;
        private Point2D point3;

        public ControlSet(Point2D p0, Point2D p1, Point2D p2, Point2D p3) {
            this.point0 = p0;
            this.point1 = p1;
            this.point2 = p2;
            this.point3 = p3;
        }

        public double breadth() {
            double f0 = this.point0.getX();
            double f4 = this.point0.getY();
            double f1 = this.point1.getX();
            double f5 = this.point1.getY();
            double f2 = this.point2.getX();
            double f6 = this.point2.getY();
            double f3 = this.point3.getX();
            double f7 = this.point3.getY();
            if (Math.abs(f0 - f3) < CubicToLinePathConstructor.this.resolution && Math.abs(f4 - f7) < CubicToLinePathConstructor.this.resolution) {
                double f8 = Math.abs(f1 - f0) + Math.abs(f5 - f4);
                double f10 = Math.abs(f2 - f0) + Math.abs(f6 - f4);
                return Math.max(f10, f8);
            }
            double d0 = f4 - f7;
            double d1 = f3 - f0;
            double f12 = Math.sqrt(d0 * d0 + d1 * d1);
            double d2 = f3 * f4 - f0 * f7;
            double f9 = Math.abs(d0 * f2 + d1 * f6 - d2) / f12;
            double f11 = Math.abs(d0 * f1 + d1 * f5 - d2) / f12;
            return Math.max(f9, f11);
        }

        public ControlSet bisect() {
            Point2D p0 = this.average(this.point0, this.point1);
            Point2D p1 = this.average(this.point1, this.point2);
            Point2D p2 = this.average(this.point2, this.point3);
            Point2D p3 = this.average(p0, p1);
            Point2D p4 = this.average(p1, p2);
            Point2D p5 = this.average(p3, p4);
            ControlSet controlset = new ControlSet(p5, p4, p2, this.point3);
            this.point1 = p0;
            this.point2 = p3;
            this.point3 = p5;
            return controlset;
        }

        public Point2D average(Point2D p1, Point2D p2) {
            return new Point2D.Double((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
        }

        public Point2D getPoint() {
            return this.point3;
        }
    }
}

