/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.util.Objects;
import net.schmizz.sshj.common.ECDSACurve;
import net.schmizz.sshj.common.SecurityUtils;

public class ECDSAKeyFactory {
    private ECDSAKeyFactory() {
    }

    public static PrivateKey getPrivateKey(BigInteger privateKeyInteger, ECDSACurve ecdsaCurve) throws GeneralSecurityException {
        Objects.requireNonNull(privateKeyInteger, "Private Key integer required");
        Objects.requireNonNull(ecdsaCurve, "Curve required");
        ECParameterSpec parameterSpec = ECDSAKeyFactory.getParameterSpec(ecdsaCurve);
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(privateKeyInteger, parameterSpec);
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("ECDSA");
        return keyFactory.generatePrivate(privateKeySpec);
    }

    public static PublicKey getPublicKey(ECPoint point, ECDSACurve ecdsaCurve) throws GeneralSecurityException {
        Objects.requireNonNull(point, "Elliptic Curve Point required");
        Objects.requireNonNull(ecdsaCurve, "Curve required");
        ECParameterSpec parameterSpec = ECDSAKeyFactory.getParameterSpec(ecdsaCurve);
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(point, parameterSpec);
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("ECDSA");
        return keyFactory.generatePublic(publicKeySpec);
    }

    private static ECParameterSpec getParameterSpec(ECDSACurve ecdsaCurve) throws GeneralSecurityException {
        ECGenParameterSpec genParameterSpec = new ECGenParameterSpec(ecdsaCurve.getCurveName());
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("EC");
        algorithmParameters.init(genParameterSpec);
        return algorithmParameters.getParameterSpec(ECParameterSpec.class);
    }
}

