/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.sourceforge.jnlp.util.UrlUtils;

public class ClasspathMatcher {
    public static final String PROTOCOL_DELIMITER = "://";
    public static final String PATH_DELIMITER = "/";
    public static final String PORT_DELIMITER = ":";
    private final String source;
    private Parts parts;

    private ClasspathMatcher(String source) {
        this.source = source;
    }

    Parts getParts() {
        return this.parts;
    }

    public String toString() {
        return this.source;
    }

    public static ClasspathMatcher compile(String source) {
        ClasspathMatcher r = new ClasspathMatcher(source);
        r.parts = ClasspathMatcher.splitToParts(source);
        r.parts.compilePartsToPatterns();
        return r;
    }

    private boolean match(URL url, boolean includePath) {
        boolean always;
        String protocol = url.getProtocol();
        int port = url.getPort();
        String domain = url.getHost();
        String path = url.getPath();
        boolean bl = always = this.parts.matchPort(port) && this.parts.matchProtocol(protocol) && this.parts.matchDomain(domain);
        if (includePath) {
            return always && (this.parts.matchPath(UrlUtils.sanitizeLastSlash(path)) || this.parts.matchPath(path));
        }
        return always;
    }

    public boolean match(URL url) {
        return this.match(url, false);
    }

    public boolean matchWithPath(URL url) {
        return this.match(url, true);
    }

    public boolean matchWithoutPath(URL url) {
        return this.match(url, false);
    }

    static boolean hasProtocol(String source) {
        int indexOfProtocolMark = source.indexOf(PROTOCOL_DELIMITER);
        if (indexOfProtocolMark < 0) {
            return false;
        }
        int indexofFirstDot = source.indexOf(".");
        if (indexofFirstDot >= 0) {
            return indexOfProtocolMark < indexofFirstDot;
        }
        String degradedProtocol = source.replace(PROTOCOL_DELIMITER, "%%%");
        int indexofFirstPath = degradedProtocol.indexOf(PATH_DELIMITER);
        if (indexofFirstPath >= 0) {
            return indexOfProtocolMark < indexofFirstPath;
        }
        return true;
    }

    private static String[] extractProtocolImpl(String source) {
        return ClasspathMatcher.splitOnFirst(source, PROTOCOL_DELIMITER);
    }

    static String extractProtocol(String source) {
        return ClasspathMatcher.extractProtocolImpl(source)[0];
    }

    static String removeProtocol(String source) {
        return ClasspathMatcher.extractProtocolImpl(source)[1];
    }

    static boolean hasPath(String source) {
        return source.contains(PATH_DELIMITER);
    }

    private static String[] extractPathImpl(String source) {
        return ClasspathMatcher.splitOnFirst(source, PATH_DELIMITER);
    }

    static String extractPath(String source) {
        return ClasspathMatcher.extractPathImpl(source)[1];
    }

    static String removePath(String source) {
        return ClasspathMatcher.extractPathImpl(source)[0];
    }

    static boolean hasPort(String source) {
        return source.contains(PORT_DELIMITER);
    }

    private static String[] extractPortImpl(String source) {
        return ClasspathMatcher.splitOnFirst(source, PORT_DELIMITER);
    }

    static String extractPort(String source) {
        return ClasspathMatcher.extractPortImpl(source)[1];
    }

    static String removePort(String source) {
        return ClasspathMatcher.extractPortImpl(source)[0];
    }

    public static String[] splitOnFirst(String source, String delimiter) {
        String s1 = source.substring(0, source.indexOf(delimiter));
        String s2 = source.substring(source.indexOf(delimiter) + delimiter.length());
        return new String[]{s1, s2};
    }

    public static String sourceToRegExString(String s) {
        if (s.equals("*")) {
            return ".*";
        }
        return ClasspathMatcher.convertWildcardToRegEx(s);
    }

    private static String convertWildcardToRegEx(String s) {
        if (s.startsWith("*") && s.endsWith("*")) {
            return "^.*" + Pattern.quote(s.substring(1, s.length() - 1)) + ".*$";
        }
        if (s.endsWith("*")) {
            return "^" + Pattern.quote(s.substring(0, s.length() - 1)) + ".*$";
        }
        if (s.startsWith("*")) {
            return "^.*" + Pattern.quote(s.substring(1)) + "$";
        }
        return "^" + Pattern.quote(s) + "$";
    }

    public static Pattern sourceToRegEx(String s) {
        return Pattern.compile(ClasspathMatcher.sourceToRegExString(s));
    }

    static Parts splitToParts(String source) {
        Parts parts = new Parts();
        String urlWithoutprotocol = source;
        boolean haveProtocol = ClasspathMatcher.hasProtocol(source);
        if (haveProtocol) {
            parts.protocol = ClasspathMatcher.extractProtocol(source);
            urlWithoutprotocol = ClasspathMatcher.removeProtocol(source);
        } else {
            parts.protocol = "*";
        }
        boolean havePath = ClasspathMatcher.hasPath(urlWithoutprotocol);
        String remianedUrl = urlWithoutprotocol;
        if (havePath) {
            parts.path = ClasspathMatcher.extractPath(urlWithoutprotocol);
            remianedUrl = ClasspathMatcher.removePath(urlWithoutprotocol);
        } else {
            parts.path = "*";
        }
        if (parts.path.length() == 0) {
            parts.path = "*";
        }
        boolean havePort = ClasspathMatcher.hasPort(remianedUrl);
        String domain = remianedUrl;
        if (havePort) {
            parts.port = ClasspathMatcher.extractPort(remianedUrl);
            domain = ClasspathMatcher.removePort(remianedUrl);
        } else {
            parts.port = "*";
        }
        if (parts.port.length() == 0) {
            parts.port = "*";
        }
        parts.domain = domain;
        return parts;
    }

    static class Parts {
        String protocol;
        String domain;
        String port;
        String path;
        Pattern protocolRegEx;
        Pattern domainRegEx;
        Pattern portRegEx;
        Pattern pathRegEx;

        Parts() {
        }

        public String toString() {
            return this.protocol + ClasspathMatcher.PROTOCOL_DELIMITER + this.domain + ClasspathMatcher.PORT_DELIMITER + this.port + ClasspathMatcher.PATH_DELIMITER + this.path;
        }

        public void compilePartsToPatterns() {
            this.protocolRegEx = ClasspathMatcher.sourceToRegEx(this.protocol);
            this.domainRegEx = Parts.domainToRegEx(this.domain);
            this.portRegEx = ClasspathMatcher.sourceToRegEx(this.port);
            this.pathRegEx = ClasspathMatcher.sourceToRegEx(this.path);
        }

        private boolean matchDomain(String source) {
            return Parts.generalMatch(source, this.domainRegEx);
        }

        private boolean matchProtocol(String source) {
            return Parts.generalMatch(source, this.protocolRegEx);
        }

        private boolean matchPath(String source) {
            if (source.startsWith(ClasspathMatcher.PATH_DELIMITER)) {
                source = source.substring(1);
            }
            return Parts.generalMatch(source, this.pathRegEx);
        }

        private boolean matchPort(int port) {
            return Parts.generalMatch(Integer.toString(port), this.portRegEx);
        }

        private static boolean generalMatch(String input, Pattern pattern) {
            return pattern.matcher(input).matches();
        }

        private static Pattern domainToRegEx(String domain) {
            String pre = "";
            String post = "";
            if (domain.startsWith("*.")) {
                pre = "(" + ClasspathMatcher.convertWildcardToRegEx(domain.substring(2)) + ")|(";
                post = ")";
            }
            return Pattern.compile(pre + ClasspathMatcher.sourceToRegExString(domain) + post);
        }
    }

    public static class ClasspathMatchers {
        private final ArrayList<ClasspathMatcher> matchers;
        private final boolean includePath;

        ArrayList<ClasspathMatcher> getMatchers() {
            return this.matchers;
        }

        public static ClasspathMatchers compile(String s) {
            return ClasspathMatchers.compile(s, false);
        }

        public static ClasspathMatchers compile(String s, boolean includePath) {
            if (s == null) {
                return new ClasspathMatchers(new ArrayList<ClasspathMatcher>(0), includePath);
            }
            String[] splitted = s.trim().split("\\s+");
            ArrayList<ClasspathMatcher> matchers = new ArrayList<ClasspathMatcher>(splitted.length);
            for (String string : splitted) {
                matchers.add(ClasspathMatcher.compile(string.trim()));
            }
            return new ClasspathMatchers(matchers, includePath);
        }

        public ClasspathMatchers(ArrayList<ClasspathMatcher> matchers, boolean includePath) {
            this.matchers = matchers;
            this.includePath = includePath;
        }

        public boolean matches(URL s) {
            return this.or(s);
        }

        private boolean or(URL s) {
            for (ClasspathMatcher classpathMatcher : this.matchers) {
                if (!classpathMatcher.match(s, this.includePath)) continue;
                return true;
            }
            return false;
        }

        private boolean and(URL s) {
            for (ClasspathMatcher classpathMatcher : this.matchers) {
                if (classpathMatcher.match(s, this.includePath)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (ClasspathMatcher classpathMatcher : this.matchers) {
                sb.append(classpathMatcher.toString()).append(" ");
            }
            return sb.toString();
        }
    }
}

