require 'spec_helper'

RSpec.describe Msf::Exploit::Local::Timespec do
  describe '.valid_timespec?' do
    it 'returns true for military time' do
      expect(Msf::Exploit::Local::Timespec.valid_timespec?('14:30')).to eq(true)
    end

    it 'returns true for 12hr time' do
      expect(Msf::Exploit::Local::Timespec.valid_timespec?('2:15 PM')).to eq(true)
    end

    it 'returns true for midnight' do
      expect(Msf::Exploit::Local::Timespec.valid_timespec?('midnight')).to eq(true)
    end

    it 'returns true for now' do
      expect(Msf::Exploit::Local::Timespec.valid_timespec?('now')).to eq(true)
    end

    it 'returns true for now plus time' do
      expect(Msf::Exploit::Local::Timespec.valid_timespec?('now + 10 minutes')).to eq(true)
    end

    it 'returns true for relative days' do
      expect(Msf::Exploit::Local::Timespec.valid_timespec?('next Monday')).to eq(true)
      expect(Msf::Exploit::Local::Timespec.valid_timespec?('last Friday')).to eq(true) # unlikely to ever be used for our context
    end

    it 'returns true for mm/dd/yy based date' do
      expect(Msf::Exploit::Local::Timespec.valid_timespec?('07/04/23')).to eq(true)
    end

    it 'returns true for mmddyy based date' do
      expect(Msf::Exploit::Local::Timespec.valid_timespec?('010124')).to eq(true)
    end

    it 'returns true for dd.mm.yyyy based date' do
      expect(Msf::Exploit::Local::Timespec.valid_timespec?('31.12.2023')).to eq(true)
    end
  end
end