/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import java.util.Map;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;
import org.opensearch.search.aggregations.pipeline.BucketMetricsPipelineAggregator;
import org.opensearch.search.aggregations.pipeline.InternalSimpleValue;

public class AvgBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    private int count = 0;
    private double sum = 0.0;

    AvgBucketPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat format, Map<String, Object> metadata) {
        super(name, bucketsPaths, gapPolicy, format, metadata);
    }

    @Override
    protected void preCollection() {
        this.count = 0;
        this.sum = 0.0;
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        ++this.count;
        this.sum += bucketValue.doubleValue();
    }

    @Override
    protected InternalAggregation buildAggregation(Map<String, Object> metadata) {
        double avgValue = this.count == 0 ? Double.NaN : this.sum / (double)this.count;
        return new InternalSimpleValue(this.name(), avgValue, this.format, metadata);
    }
}

