/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.window.frame;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.common.patterns.BrainLogParser;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.window.WindowDefinition;
import org.opensearch.sql.expression.window.frame.PeerRowsWindowFrame;
import shaded.com.google.common.collect.PeekingIterator;

public class BufferPatternRowsWindowFrame
extends PeerRowsWindowFrame {
    private final Expression sourceField;
    private final BrainLogParser logParser;
    private final List<List<String>> preprocessedMessages;

    public BufferPatternRowsWindowFrame(WindowDefinition windowDefinition, BrainLogParser logParser, Expression sourceField) {
        super(windowDefinition);
        this.logParser = logParser;
        this.sourceField = sourceField;
        this.preprocessedMessages = new ArrayList<List<String>>();
    }

    @Override
    public void load(PeekingIterator<ExprValue> it) {
        if (this.hasNext()) {
            return;
        }
        this.preprocessedMessages.clear();
        this.loadAllRows(it);
        List<String> logMessages = this.peers.stream().map(exprValue -> {
            ExprValue value = this.sourceField.valueOf(exprValue.bindingTuples());
            return value.isNull() || value.isMissing() ? "" : value.stringValue();
        }).collect(Collectors.toList());
        this.preprocessedMessages.addAll(this.logParser.preprocessAllLogs(logMessages));
    }

    public List<String> currentPreprocessedMessage() {
        return this.preprocessedMessages.get(this.position);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BufferPatternRowsWindowFrame)) {
            return false;
        }
        BufferPatternRowsWindowFrame other = (BufferPatternRowsWindowFrame)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Expression this$sourceField = this.sourceField;
        Expression other$sourceField = other.sourceField;
        if (this$sourceField == null ? other$sourceField != null : !this$sourceField.equals(other$sourceField)) {
            return false;
        }
        BrainLogParser this$logParser = this.getLogParser();
        BrainLogParser other$logParser = other.getLogParser();
        return !(this$logParser == null ? other$logParser != null : !((Object)this$logParser).equals(other$logParser));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BufferPatternRowsWindowFrame;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Expression $sourceField = this.sourceField;
        result = result * 59 + ($sourceField == null ? 43 : $sourceField.hashCode());
        BrainLogParser $logParser = this.getLogParser();
        result = result * 59 + ($logParser == null ? 43 : ((Object)$logParser).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BufferPatternRowsWindowFrame(sourceField=" + String.valueOf(this.sourceField) + ", logParser=" + String.valueOf(this.getLogParser()) + ", preprocessedMessages=" + String.valueOf(this.preprocessedMessages) + ")";
    }

    @Generated
    public BrainLogParser getLogParser() {
        return this.logParser;
    }
}

