"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiQuickSelectPopover = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _button = require("../../../button");
var _icon = require("../../../icon");
var _popover = require("../../../popover");
var _title = require("../../../title");
var _spacer = require("../../../spacer");
var _horizontal_rule = require("../../../horizontal_rule");
var _text = require("../../../text");
var _quick_select = require("./quick_select");
var _commonly_used_time_ranges = require("./commonly_used_time_ranges");
var _recently_used = require("./recently_used");
var _refresh_interval = require("./refresh_interval");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = (0, _getPrototypeOf2.default)(t); if (r) { var s = (0, _getPrototypeOf2.default)(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return (0, _possibleConstructorReturn2.default)(this, e); }; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiQuickSelectPopover = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EuiQuickSelectPopover, _Component);
  var _super = _createSuper(EuiQuickSelectPopover);
  function EuiQuickSelectPopover() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiQuickSelectPopover);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      isOpen: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "closePopover", function () {
      _this.setState({
        isOpen: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "togglePopover", function () {
      _this.setState(function (prevState) {
        return {
          isOpen: !prevState.isOpen
        };
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "applyTime", function (_ref) {
      var start = _ref.start,
        end = _ref.end,
        quickSelect = _ref.quickSelect,
        _ref$keepPopoverOpen = _ref.keepPopoverOpen,
        keepPopoverOpen = _ref$keepPopoverOpen === void 0 ? false : _ref$keepPopoverOpen;
      _this.props.applyTime({
        start: start,
        end: end
      });
      if (quickSelect) {
        _this.setState({
          prevQuickSelect: quickSelect
        });
      }
      if (!keepPopoverOpen) {
        _this.closePopover();
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderDateTimeSections", function () {
      var _this$props = _this.props,
        commonlyUsedRanges = _this$props.commonlyUsedRanges,
        dateFormat = _this$props.dateFormat,
        end = _this$props.end,
        isAutoRefreshOnly = _this$props.isAutoRefreshOnly,
        recentlyUsedRanges = _this$props.recentlyUsedRanges,
        start = _this$props.start;
      var prevQuickSelect = _this.state.prevQuickSelect;
      if (isAutoRefreshOnly) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_quick_select.EuiQuickSelect, {
        applyTime: _this.applyTime,
        start: start,
        end: end,
        prevQuickSelect: prevQuickSelect
      }), /*#__PURE__*/_react.default.createElement(_commonly_used_time_ranges.EuiCommonlyUsedTimeRanges, {
        applyTime: _this.applyTime,
        commonlyUsedRanges: commonlyUsedRanges
      }), /*#__PURE__*/_react.default.createElement(_recently_used.EuiRecentlyUsed, {
        applyTime: _this.applyTime,
        commonlyUsedRanges: commonlyUsedRanges,
        dateFormat: dateFormat,
        recentlyUsedRanges: recentlyUsedRanges
      }), _this.renderCustomQuickSelectPanels());
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderCustomQuickSelectPanels", function () {
      var customQuickSelectPanels = _this.props.customQuickSelectPanels;
      if (!customQuickSelectPanels) {
        return null;
      }
      return customQuickSelectPanels.map(function (_ref2) {
        var title = _ref2.title,
          content = _ref2.content;
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          key: title
        }, /*#__PURE__*/_react.default.createElement(_title.EuiTitle, {
          size: "xxxs"
        }, /*#__PURE__*/_react.default.createElement("span", null, title)), /*#__PURE__*/_react.default.createElement(_spacer.EuiSpacer, {
          size: "s"
        }), /*#__PURE__*/_react.default.createElement(_text.EuiText, {
          size: "s",
          className: "euiQuickSelectPopover__section"
        }, /*#__PURE__*/_react.default.cloneElement(content, {
          applyTime: _this.applyTime
        })), /*#__PURE__*/_react.default.createElement(_horizontal_rule.EuiHorizontalRule, {
          margin: "s"
        }));
      });
    });
    return _this;
  }
  (0, _createClass2.default)(EuiQuickSelectPopover, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        applyRefreshInterval = _this$props2.applyRefreshInterval,
        isAutoRefreshOnly = _this$props2.isAutoRefreshOnly,
        isDisabled = _this$props2.isDisabled,
        isPaused = _this$props2.isPaused,
        refreshInterval = _this$props2.refreshInterval;
      var isOpen = this.state.isOpen;
      var quickSelectButton = /*#__PURE__*/_react.default.createElement(_button.EuiButtonEmpty, {
        className: "euiFormControlLayout__prepend",
        textProps: {
          className: 'euiQuickSelectPopover__buttonText'
        },
        onClick: this.togglePopover,
        "aria-label": "Date quick select",
        size: "xs",
        iconType: "arrowDown",
        iconSide: "right",
        isDisabled: isDisabled,
        "data-test-subj": "superDatePickerToggleQuickMenuButton"
      }, /*#__PURE__*/_react.default.createElement(_icon.EuiIcon, {
        type: !isAutoRefreshOnly && isPaused ? 'calendar' : 'clock'
      }));
      return /*#__PURE__*/_react.default.createElement(_popover.EuiPopover, {
        button: quickSelectButton,
        isOpen: isOpen,
        closePopover: this.closePopover,
        panelPaddingSize: "s",
        anchorPosition: "downLeft",
        anchorClassName: "euiQuickSelectPopover__anchor"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "euiQuickSelectPopover__content",
        "data-test-subj": "superDatePickerQuickMenu"
      }, this.renderDateTimeSections(), /*#__PURE__*/_react.default.createElement(_refresh_interval.EuiRefreshInterval, {
        applyRefreshInterval: applyRefreshInterval,
        isPaused: isPaused,
        refreshInterval: refreshInterval
      })));
    }
  }]);
  return EuiQuickSelectPopover;
}(_react.Component);
exports.EuiQuickSelectPopover = EuiQuickSelectPopover;
EuiQuickSelectPopover.propTypes = {
  applyRefreshInterval: _propTypes.default.func,
  applyTime: _propTypes.default.func.isRequired,
  commonlyUsedRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired).isRequired,
  customQuickSelectPanels: _propTypes.default.arrayOf(_propTypes.default.shape({
    title: _propTypes.default.string.isRequired,
    content: _propTypes.default.element.isRequired
  }).isRequired),
  dateFormat: _propTypes.default.string.isRequired,
  end: _propTypes.default.string.isRequired,
  isAutoRefreshOnly: _propTypes.default.bool.isRequired,
  isDisabled: _propTypes.default.bool.isRequired,
  isPaused: _propTypes.default.bool.isRequired,
  recentlyUsedRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired).isRequired,
  refreshInterval: _propTypes.default.number.isRequired,
  start: _propTypes.default.string.isRequired
};