
use builtin;
use str;

set edit:completion:arg-completer[ty] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'ty'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'ty'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand check 'Check a project for type errors'
            cand server 'Start the language server'
            cand version 'Display ty''s version'
            cand generate-shell-completion 'Generate shell completion'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'ty;check'= {
            cand --project 'Run the command within the given project directory'
            cand --python 'Path to your project''s Python environment or interpreter'
            cand --typeshed 'Custom directory to use for stdlib typeshed stubs'
            cand --extra-search-path 'Additional path to use as a module-resolution source (can be passed multiple times)'
            cand --python-version 'Python version to assume when resolving types'
            cand --python-platform 'Target platform to assume when resolving types'
            cand --error 'Treat the given rule as having severity ''error''. Can be specified multiple times.'
            cand --warn 'Treat the given rule as having severity ''warn''. Can be specified multiple times.'
            cand --ignore 'Disables the rule. Can be specified multiple times.'
            cand -c 'A TOML `<KEY> = <VALUE>` pair overriding a specific configuration option.'
            cand --config 'A TOML `<KEY> = <VALUE>` pair overriding a specific configuration option.'
            cand --config-file 'The path to a `ty.toml` file to use for configuration'
            cand --output-format 'The format to use for printing diagnostic messages'
            cand --exclude 'Glob patterns for files to exclude from type checking'
            cand --color 'Control when colored output is used'
            cand --add-ignore 'Adds `ty: ignore` comments to suppress all rule diagnostics'
            cand -v 'Use verbose output (or `-vv` and `-vvv` for more verbose output)'
            cand --verbose 'Use verbose output (or `-vv` and `-vvv` for more verbose output)'
            cand -q 'Use quiet output (or `-qq` for silent output)'
            cand --quiet 'Use quiet output (or `-qq` for silent output)'
            cand --error-on-warning 'Use exit code 1 if there are any warning-level diagnostics'
            cand --exit-zero 'Always use exit code 0, even when there are error-level diagnostics'
            cand -W 'Watch files for changes and recheck files related to the changed files'
            cand --watch 'Watch files for changes and recheck files related to the changed files'
            cand --respect-ignore-files 'Respect file exclusions via `.gitignore` and other standard ignore files. Use `--no-respect-ignore-files` to disable'
            cand --no-respect-ignore-files 'no-respect-ignore-files'
            cand --force-exclude 'Enforce exclusions, even for paths passed to ty directly on the command-line. Use `--no-force-exclude` to disable'
            cand --no-force-exclude 'no-force-exclude'
            cand --no-progress 'Hide all progress outputs'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'ty;server'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'ty;version'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'ty;generate-shell-completion'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'ty;help'= {
            cand check 'Check a project for type errors'
            cand server 'Start the language server'
            cand version 'Display ty''s version'
            cand generate-shell-completion 'Generate shell completion'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'ty;help;check'= {
        }
        &'ty;help;server'= {
        }
        &'ty;help;version'= {
        }
        &'ty;help;generate-shell-completion'= {
        }
        &'ty;help;help'= {
        }
    ]
    $completions[$command]
}
