/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.statushandlers;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;

public class StatusHandlerDescriptor
implements IPluginContribution {
    private AbstractStatusHandler cachedInstance;
    private static final String PREFIX = "prefix";
    private final IConfigurationElement configElement;
    private final String id;
    private final String pluginId;
    private String prefix;

    public StatusHandlerDescriptor(IConfigurationElement configElement) {
        this.configElement = configElement;
        this.id = configElement.getAttribute("id");
        this.pluginId = configElement.getContributor().getName();
    }

    public synchronized AbstractStatusHandler getStatusHandler() throws CoreException {
        if (this.cachedInstance == null) {
            AbstractStatusHandler statusHandler = (AbstractStatusHandler)this.configElement.createExecutableExtension("class");
            statusHandler.setId(this.configElement.getAttribute("id"));
            IConfigurationElement[] parameters = this.configElement.getChildren("parameter");
            HashMap<String, String> params = new HashMap<String, String>();
            IConfigurationElement[] iConfigurationElementArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                params.put(configElement.getAttribute("name"), configElement.getAttribute("value"));
                ++n2;
            }
            statusHandler.setParams(params);
            this.cachedInstance = statusHandler;
        }
        return this.cachedInstance;
    }

    public String getPrefix() {
        IConfigurationElement[] parameters;
        IConfigurationElement[] iConfigurationElementArray = parameters = this.configElement.getChildren("parameter");
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            if (configElement.getAttribute("name").equals(PREFIX)) {
                this.prefix = configElement.getAttribute("value");
            }
            ++n2;
        }
        return this.prefix;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getLocalId() {
        return this.id;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }
}

