/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeNode;
import ghidra.framework.main.datatree.AbstractFileListFlavorHandler;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public final class LinuxFileUrlHandler
extends AbstractFileListFlavorHandler {
    public static final DataFlavor linuxFileUrlFlavor = new DataFlavor("application/x-java-serialized-object;class=java.lang.String", "String file URL");

    public void handle(PluginTool tool, Object transferData, DropTargetDropEvent e, DataFlavor f) {
        List<File> files = this.toFiles(transferData);
        this.doImport(null, files, tool, tool.getToolFrame());
    }

    public boolean handle(PluginTool tool, DataTree dataTree, GTreeNode destinationNode, Object transferData, int dropAction) {
        List<File> files = this.toFiles(transferData);
        if (files.isEmpty()) {
            return false;
        }
        this.doImport(DataTree.getRealInternalFolderForNode((GTreeNode)destinationNode), files, tool, (Component)dataTree);
        return true;
    }

    private List<File> toFiles(Object transferData) {
        return this.toFiles(transferData, s -> {
            try {
                return new File(new URL(s.replaceAll(" ", "%20")).toURI());
            }
            catch (MalformedURLException e) {
                Msg.trace((Object)this, (Object)("Not a URL: '" + s + "'"), (Throwable)e);
                return null;
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Unable to open dropped URL: '" + s + "'"), (Throwable)e);
                return null;
            }
        });
    }

    private List<File> toFiles(Object transferData, Function<String, File> urlToFileConverter) {
        String[] urls;
        ArrayList<File> files = new ArrayList<File>();
        String string = (String)transferData;
        for (String url : urls = string.split("\\n")) {
            File file = urlToFileConverter.apply(url);
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }
}

