/*
 * Decompiled with CFR 0.152.
 */
package generic.random;

import ghidra.util.Msg;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class SecureRandomFactory {
    private static SecureRandom random;
    private static final String[] preferredAlgorithm;

    private static synchronized void initialize() {
        if (random != null) {
            return;
        }
        Msg.info(SecureRandomFactory.class, (Object)"Initializing Random Number Generator...");
        for (String algorithm : preferredAlgorithm) {
            try {
                random = SecureRandom.getInstance(algorithm);
                Msg.info(SecureRandomFactory.class, (Object)("Random Number Generator initialization complete: " + algorithm));
                return;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
        }
        random = new SecureRandom();
        Msg.info(SecureRandomFactory.class, (Object)"Random Number Generator initialization complete: default");
    }

    public static SecureRandom getSecureRandom() {
        SecureRandomFactory.initialize();
        return random;
    }

    private SecureRandomFactory() {
    }

    static {
        preferredAlgorithm = new String[]{"NativePRNGNonBlocking", "SHA1PRNG"};
    }
}

