/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.MicrosoftCodeAnalyzerPlugin;

import ghidra.app.plugin.prototype.MicrosoftCodeAnalyzerPlugin.PEUtil;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.datatype.microsoft.ThreadEnvironmentBlock;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class TEBAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Windows x86 Thread Environment Block (TEB) Analyzer";
    private static final String DESCRIPTION = "Create and mark up a Thread Environment Block. Set FS or GS segments to point to it.";
    protected static final String ADDRESS_OPTION_NAME = "Starting Address of the TEB";
    protected static final String ADDRESS_OPTION_DESCRIPTION = "Address in RAM where TEB is located (must not be mapped to another block)";
    protected static final String ADDRESS_OPTION_DEFAULT_VALUE = "";
    protected static final String VERSION_OPTION_NAME = "Windows OS Version";
    protected static final String VERSION_OPTION_DESCRIPTION = "Version of the TEB fields to lay down. Many common fields persist across multiple OS versions.";
    protected static final ThreadEnvironmentBlock.WinVersion VERSION_OPTION_DEFAULT_VALUE = ThreadEnvironmentBlock.WinVersion.WIN_7;
    protected String tebAddressString = "";
    protected ThreadEnvironmentBlock.WinVersion winVersion = VERSION_OPTION_DEFAULT_VALUE;

    public TEBAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.after().after());
        this.setDefaultEnablement(true);
    }

    public boolean canAnalyze(Program program) {
        if (!program.getLanguageID().getIdAsString().startsWith("x86")) {
            return false;
        }
        return PEUtil.isVisualStudioOrClangPe(program);
    }

    private Address findBlockLocation(Program program, boolean is64Bit, int blockSize) {
        MemoryBlock[] blocks;
        Address endAddr;
        AddressSpace addrSpace;
        Address startAddr;
        long offset = is64Bit ? 0xFF00000000L : 0xFFDFF000L;
        Memory memory = program.getMemory();
        if (!memory.intersects(startAddr = (addrSpace = program.getAddressFactory().getDefaultAddressSpace()).getAddress(offset), endAddr = startAddr.add((long)(blockSize - 1)))) {
            return startAddr;
        }
        for (MemoryBlock block : blocks = memory.getBlocks()) {
            Address addr = block.getEnd();
            if (addr.getAddressSpace() != addrSpace || startAddr.compareTo((Object)addr) >= 0) continue;
            startAddr = addr;
        }
        startAddr = startAddr.add(1L);
        return startAddr;
    }

    private void setTEBAddress(Program program, ThreadEnvironmentBlock teb) {
        long offset;
        try {
            offset = Long.parseLong(this.tebAddressString, 16);
        }
        catch (NumberFormatException ex) {
            offset = 0L;
        }
        Address addr = offset == 0L ? this.findBlockLocation(program, teb.is64(), teb.getBlockSize()) : program.getAddressFactory().getDefaultAddressSpace().getAddress(offset);
        teb.setAddress(addr);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        if (!program.hasExclusiveAccess()) {
            log.appendMsg("WARNING: Unable to perform Thread Environment Block (TEB) analysis - exclusive checkout required");
            return false;
        }
        MemoryBlock block = program.getMemory().getBlock("tdb");
        if (block != null) {
            return true;
        }
        try {
            ThreadEnvironmentBlock teb = new ThreadEnvironmentBlock(program, this.winVersion);
            this.setTEBAddress(program, teb);
            teb.createBlocksAndSymbols();
            teb.setRegisterValue();
            return true;
        }
        catch (Exception e) {
            log.appendMsg("Failed to create the Thread Environment Block (TEB) - see console log");
            Msg.error((Object)((Object)this), (Object)"Failed to create the Thread Environment Block (TEB)", (Throwable)e);
            return false;
        }
    }

    public void registerOptions(Options options, Program program) {
        options.registerOption(ADDRESS_OPTION_NAME, (Object)this.tebAddressString, null, ADDRESS_OPTION_DESCRIPTION);
        options.registerOption(VERSION_OPTION_NAME, (Object)this.winVersion, null, VERSION_OPTION_DESCRIPTION);
    }

    public void optionsChanged(Options options, Program program) {
        this.tebAddressString = options.getString(ADDRESS_OPTION_NAME, this.tebAddressString);
        this.winVersion = (ThreadEnvironmentBlock.WinVersion)options.getEnum(VERSION_OPTION_NAME, (Enum)this.winVersion);
    }
}

