/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalVariableFlags;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.NameMsSymbol;

public abstract class AbstractLocalSymbolInOptimizedCodeMsSymbol
extends AbstractMsSymbol
implements NameMsSymbol {
    protected RecordNumber typeRecordNumber;
    protected LocalVariableFlags localVariableFlags;
    protected String name;

    public AbstractLocalSymbolInOptimizedCodeMsSymbol(AbstractPdb pdb, PdbByteReader reader, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.localVariableFlags = new LocalVariableFlags(reader);
        this.name = reader.parseString(pdb, strType);
        reader.align4();
    }

    public RecordNumber getTypeRecordNumber() {
        return this.typeRecordNumber;
    }

    public LocalVariableFlags getLocalVariableFlags() {
        return this.localVariableFlags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void emit(StringBuilder builder) {
        StringBuilder myBuilder = new StringBuilder();
        myBuilder.append(String.format("%08X ", this.typeRecordNumber.getNumber()));
        this.localVariableFlags.emit(myBuilder);
        builder.append(String.format("%s: %s, %s", this.getSymbolTypeName(), myBuilder.toString(), this.name));
    }
}

