/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opensearch.Version;
import org.opensearch.cluster.block.ClusterBlocks;
import org.opensearch.common.io.Streams;
import org.opensearch.common.remote.AbstractClusterMetadataWriteableBlobEntity;
import org.opensearch.common.remote.BlobPathParameters;
import org.opensearch.core.compress.Compressor;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.repositories.blobstore.ChecksumWritableBlobStoreFormat;

public class RemoteClusterBlocks
extends AbstractClusterMetadataWriteableBlobEntity<ClusterBlocks> {
    public static final String CLUSTER_BLOCKS = "blocks";
    public final ChecksumWritableBlobStoreFormat<ClusterBlocks> clusterBlocksFormat;
    private ClusterBlocks clusterBlocks;
    private long stateVersion;

    public RemoteClusterBlocks(ClusterBlocks clusterBlocks, long stateVersion, String clusterUUID, Compressor compressor) {
        super(clusterUUID, compressor, null);
        this.clusterBlocks = clusterBlocks;
        this.stateVersion = stateVersion;
        this.clusterBlocksFormat = new ChecksumWritableBlobStoreFormat(CLUSTER_BLOCKS, ClusterBlocks::readFrom);
    }

    public RemoteClusterBlocks(String blobName, String clusterUUID, Compressor compressor, Version version) {
        super(clusterUUID, compressor, null);
        this.blobName = blobName;
        this.clusterBlocksFormat = new ChecksumWritableBlobStoreFormat(CLUSTER_BLOCKS, ClusterBlocks::readFrom, version);
    }

    @Override
    public BlobPathParameters getBlobPathParameters() {
        return new BlobPathParameters(List.of("ephemeral"), CLUSTER_BLOCKS);
    }

    @Override
    public String getType() {
        return CLUSTER_BLOCKS;
    }

    @Override
    public String generateBlobFileName() {
        String blobFileName;
        this.blobFileName = blobFileName = String.join((CharSequence)"__", this.getBlobPathParameters().getFilePrefix(), RemoteStoreUtils.invertLong(this.stateVersion), RemoteStoreUtils.invertLong(System.currentTimeMillis()), String.valueOf(1));
        return blobFileName;
    }

    @Override
    public ClusterMetadataManifest.UploadedMetadata getUploadedMetadata() {
        assert (this.blobName != null);
        return new ClusterMetadataManifest.UploadedMetadataAttribute(CLUSTER_BLOCKS, this.blobName);
    }

    @Override
    public InputStream serialize() throws IOException {
        return this.clusterBlocksFormat.serialize(this.clusterBlocks, this.generateBlobFileName(), this.getCompressor()).streamInput();
    }

    @Override
    public ClusterBlocks deserialize(InputStream inputStream) throws IOException {
        return this.clusterBlocksFormat.deserialize(this.blobName, Streams.readFully(inputStream));
    }
}

