/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.reindex_rethrottle;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.BaseNode;
import org.opensearch.client.opensearch.core.reindex_rethrottle.ReindexTask;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ReindexNode
extends BaseNode
implements ToCopyableBuilder<Builder, ReindexNode> {
    @Nonnull
    private final Map<String, ReindexTask> tasks;
    public static final JsonpDeserializer<ReindexNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReindexNode::setupReindexNodeDeserializer);

    private ReindexNode(Builder builder) {
        super(builder);
        this.tasks = ApiTypeHelper.unmodifiableRequired(builder.tasks, (Object)this, "tasks");
    }

    public static ReindexNode of(Function<Builder, ObjectBuilder<ReindexNode>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, ReindexTask> tasks() {
        return this.tasks;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("tasks");
        generator.writeStartObject();
        for (Map.Entry<String, ReindexTask> item0 : this.tasks.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupReindexNodeDeserializer(ObjectDeserializer<Builder> op) {
        ReindexNode.setupBaseNodeDeserializer(op);
        op.add(Builder::tasks, JsonpDeserializer.stringMapDeserializer(ReindexTask._DESERIALIZER), "tasks");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.tasks.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReindexNode other = (ReindexNode)o;
        return this.tasks.equals(other.tasks);
    }

    public static class Builder
    extends BaseNode.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ReindexNode> {
        private Map<String, ReindexTask> tasks;

        public Builder() {
        }

        private Builder(ReindexNode o) {
            super(o);
            this.tasks = Builder._mapCopy(o.tasks);
        }

        private Builder(Builder o) {
            super(o);
            this.tasks = Builder._mapCopy(o.tasks);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder tasks(Map<String, ReindexTask> map) {
            this.tasks = Builder._mapPutAll(this.tasks, map);
            return this;
        }

        @Nonnull
        public final Builder tasks(String key, ReindexTask value) {
            this.tasks = Builder._mapPut(this.tasks, key, value);
            return this;
        }

        @Nonnull
        public final Builder tasks(String key, Function<ReindexTask.Builder, ObjectBuilder<ReindexTask>> fn) {
            return this.tasks(key, fn.apply(new ReindexTask.Builder()).build());
        }

        @Override
        @Nonnull
        public ReindexNode build() {
            this._checkSingleUse();
            return new ReindexNode(this);
        }
    }
}

