# The PEP 484 type hints stub file for the QtGraphs module.
#
# Generated by SIP 6.15.1
#
# Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt6-Graphs.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing, enum

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtGui
from PyQt6 import QtNetwork
from PyQt6 import QtQml

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class Q3DScene(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    graphPositionQueryChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectionQueryPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    devicePixelRatioChanged: typing.ClassVar[QtCore.pyqtSignal]
    slicingActiveChanged: typing.ClassVar[QtCore.pyqtSignal]
    secondarySubviewOnTopChanged: typing.ClassVar[QtCore.pyqtSignal]
    secondarySubViewportChanged: typing.ClassVar[QtCore.pyqtSignal]
    primarySubViewportChanged: typing.ClassVar[QtCore.pyqtSignal]
    viewportChanged: typing.ClassVar[QtCore.pyqtSignal]
    def invalidSelectionPoint(self) -> QtCore.QPoint: ...
    def setDevicePixelRatio(self, pixelRatio: float) -> None: ...
    def devicePixelRatio(self) -> float: ...
    def isSecondarySubviewOnTop(self) -> bool: ...
    def setSecondarySubviewOnTop(self, isSecondaryOnTop: bool) -> None: ...
    def isSlicingActive(self) -> bool: ...
    def setSlicingActive(self, isSlicing: bool) -> None: ...
    def graphPositionQuery(self) -> QtCore.QPoint: ...
    def setGraphPositionQuery(self, point: QtCore.QPoint) -> None: ...
    def selectionQueryPosition(self) -> QtCore.QPoint: ...
    def setSelectionQueryPosition(self, point: QtCore.QPoint) -> None: ...
    def isPointInSecondarySubView(self, point: QtCore.QPoint) -> bool: ...
    def setSecondarySubViewport(self, secondarySubViewport: QtCore.QRect) -> None: ...
    def secondarySubViewport(self) -> QtCore.QRect: ...
    def isPointInPrimarySubView(self, point: QtCore.QPoint) -> bool: ...
    def setPrimarySubViewport(self, primarySubViewport: QtCore.QRect) -> None: ...
    def primarySubViewport(self) -> QtCore.QRect: ...
    def viewport(self) -> QtCore.QRect: ...


class QAbstract3DAxis(QtCore.QObject):

    class AxisType(enum.Enum):
        None_ = ... # type: QAbstract3DAxis.AxisType
        Category = ... # type: QAbstract3DAxis.AxisType
        Value = ... # type: QAbstract3DAxis.AxisType

    class AxisOrientation(enum.Enum):
        None_ = ... # type: QAbstract3DAxis.AxisOrientation
        X = ... # type: QAbstract3DAxis.AxisOrientation
        Y = ... # type: QAbstract3DAxis.AxisOrientation
        Z = ... # type: QAbstract3DAxis.AxisOrientation

    labelSizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    scaleLabelsByCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    def labelSize(self) -> float: ...
    def setLabelSize(self, size: float) -> None: ...
    def isScaleLabelsByCount(self) -> bool: ...
    def setScaleLabelsByCount(self, adjust: bool) -> None: ...
    titleOffsetChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleFixedChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelAutoAngleChanged: typing.ClassVar[QtCore.pyqtSignal]
    autoAdjustRangeChanged: typing.ClassVar[QtCore.pyqtSignal]
    rangeChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxChanged: typing.ClassVar[QtCore.pyqtSignal]
    minChanged: typing.ClassVar[QtCore.pyqtSignal]
    orientationChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleChanged: typing.ClassVar[QtCore.pyqtSignal]
    def titleOffset(self) -> float: ...
    def setTitleOffset(self, offset: float) -> None: ...
    def isTitleFixed(self) -> bool: ...
    def setTitleFixed(self, fixed: bool) -> None: ...
    def labelsVisible(self) -> bool: ...
    def setLabelsVisible(self, visible: bool) -> None: ...
    def isTitleVisible(self) -> bool: ...
    def setTitleVisible(self, visible: bool) -> None: ...
    def labelAutoAngle(self) -> float: ...
    def setLabelAutoAngle(self, degree: float) -> None: ...
    def setRange(self, min: float, max: float) -> None: ...
    def isAutoAdjustRange(self) -> bool: ...
    def setAutoAdjustRange(self, autoAdjust: bool) -> None: ...
    def max(self) -> float: ...
    def setMax(self, max: float) -> None: ...
    def min(self) -> float: ...
    def setMin(self, min: float) -> None: ...
    def type(self) -> 'QAbstract3DAxis.AxisType': ...
    def orientation(self) -> 'QAbstract3DAxis.AxisOrientation': ...
    def labels(self) -> list[str]: ...
    def setLabels(self, labels: collections.abc.Iterable[str|None]) -> None: ...
    def title(self) -> str: ...
    def setTitle(self, title: str|None) -> None: ...


class QAbstract3DSeries(QtCore.QObject):

    class LightingMode(enum.Enum):
        Shaded = ... # type: QAbstract3DSeries.LightingMode
        Unshaded = ... # type: QAbstract3DSeries.LightingMode

    class Mesh(enum.Enum):
        UserDefined = ... # type: QAbstract3DSeries.Mesh
        Bar = ... # type: QAbstract3DSeries.Mesh
        Cube = ... # type: QAbstract3DSeries.Mesh
        Pyramid = ... # type: QAbstract3DSeries.Mesh
        Cone = ... # type: QAbstract3DSeries.Mesh
        Cylinder = ... # type: QAbstract3DSeries.Mesh
        BevelBar = ... # type: QAbstract3DSeries.Mesh
        BevelCube = ... # type: QAbstract3DSeries.Mesh
        Sphere = ... # type: QAbstract3DSeries.Mesh
        Minimal = ... # type: QAbstract3DSeries.Mesh
        Arrow = ... # type: QAbstract3DSeries.Mesh
        Point = ... # type: QAbstract3DSeries.Mesh

    class SeriesType(enum.Enum):
        None_ = ... # type: QAbstract3DSeries.SeriesType
        Bar = ... # type: QAbstract3DSeries.SeriesType
        Scatter = ... # type: QAbstract3DSeries.SeriesType
        Surface = ... # type: QAbstract3DSeries.SeriesType

    lightingModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setLightingMode(self, lightingMode: 'QAbstract3DSeries.LightingMode') -> None: ...
    def lightingMode(self) -> 'QAbstract3DSeries.LightingMode': ...
    itemLabelVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemLabelChanged: typing.ClassVar[QtCore.pyqtSignal]
    nameChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiHighlightGradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiHighlightColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    singleHighlightGradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    singleHighlightColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    baseGradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    baseColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorStyleChanged: typing.ClassVar[QtCore.pyqtSignal]
    userDefinedMeshChanged: typing.ClassVar[QtCore.pyqtSignal]
    meshRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    meshSmoothChanged: typing.ClassVar[QtCore.pyqtSignal]
    meshChanged: typing.ClassVar[QtCore.pyqtSignal]
    visibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemLabelFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isItemLabelVisible(self) -> bool: ...
    def setItemLabelVisible(self, visible: bool) -> None: ...
    def itemLabel(self) -> str: ...
    def name(self) -> str: ...
    def setName(self, name: str|None) -> None: ...
    def multiHighlightGradient(self) -> QtGui.QLinearGradient: ...
    def setMultiHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def multiHighlightColor(self) -> QtGui.QColor: ...
    def setMultiHighlightColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def singleHighlightGradient(self) -> QtGui.QLinearGradient: ...
    def setSingleHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def singleHighlightColor(self) -> QtGui.QColor: ...
    def setSingleHighlightColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def baseGradient(self) -> QtGui.QLinearGradient: ...
    def setBaseGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def baseColor(self) -> QtGui.QColor: ...
    def setBaseColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def colorStyle(self) -> 'QGraphsTheme.ColorStyle': ...
    def setColorStyle(self, style: 'QGraphsTheme.ColorStyle') -> None: ...
    def userDefinedMesh(self) -> str: ...
    def setUserDefinedMesh(self, fileName: str|None) -> None: ...
    def setMeshAxisAndAngle(self, axis: QtGui.QVector3D, angle: float) -> None: ...
    def meshRotation(self) -> QtGui.QQuaternion: ...
    def setMeshRotation(self, rotation: QtGui.QQuaternion) -> None: ...
    def isMeshSmooth(self) -> bool: ...
    def setMeshSmooth(self, enable: bool) -> None: ...
    def mesh(self) -> 'QAbstract3DSeries.Mesh': ...
    def setMesh(self, mesh: 'QAbstract3DSeries.Mesh') -> None: ...
    def isVisible(self) -> bool: ...
    def setVisible(self, visible: bool) -> None: ...
    def itemLabelFormat(self) -> str: ...
    def setItemLabelFormat(self, format: str|None) -> None: ...
    def type(self) -> 'QAbstract3DSeries.SeriesType': ...


class QAbstractAxis(QtCore.QObject):

    class AxisType(enum.Enum):
        Value = ... # type: QAbstractAxis.AxisType
        BarCategory = ... # type: QAbstractAxis.AxisType
        DateTime = ... # type: QAbstractAxis.AxisType

    textElideModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setTextElideMode(self, elideMode: QtCore.Qt.TextElideMode) -> None: ...
    def textElideMode(self) -> QtCore.Qt.TextElideMode: ...
    alignmentChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def alignment(self) -> QtCore.Qt.AlignmentFlag: ...
    update: typing.ClassVar[QtCore.pyqtSignal]
    titleFontChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleTextChanged: typing.ClassVar[QtCore.pyqtSignal]
    subGridVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    gridVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelDelegateChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsAngleChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    lineVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    visibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setRange(self, min: typing.Any, max: typing.Any) -> None: ...
    def setMax(self, max: typing.Any) -> None: ...
    def setMin(self, min: typing.Any) -> None: ...
    def titleText(self) -> str: ...
    def setTitleText(self, title: str|None) -> None: ...
    def titleFont(self) -> QtGui.QFont: ...
    def setTitleFont(self, font: QtGui.QFont) -> None: ...
    def titleColor(self) -> QtGui.QColor: ...
    def setTitleColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def setTitleVisible(self, visible: bool = ...) -> None: ...
    def isTitleVisible(self) -> bool: ...
    def setLabelDelegate(self, newLabelDelegate: QtQml.QQmlComponent|None) -> None: ...
    def labelDelegate(self) -> QtQml.QQmlComponent|None: ...
    def labelsAngle(self) -> float: ...
    def setLabelsAngle(self, angle: float) -> None: ...
    def setLabelsVisible(self, visible: bool = ...) -> None: ...
    def labelsVisible(self) -> bool: ...
    def setSubGridVisible(self, visible: bool = ...) -> None: ...
    def isSubGridVisible(self) -> bool: ...
    def setGridVisible(self, visible: bool = ...) -> None: ...
    def isGridVisible(self) -> bool: ...
    def setLineVisible(self, visible: bool = ...) -> None: ...
    def isLineVisible(self) -> bool: ...
    def hide(self) -> None: ...
    def show(self) -> None: ...
    def setVisible(self, visible: bool = ...) -> None: ...
    def isVisible(self) -> bool: ...
    def type(self) -> 'QAbstractAxis.AxisType': ...


class QAbstractDataProxy(QtCore.QObject):

    class DataType(enum.Enum):
        None_ = ... # type: QAbstractDataProxy.DataType
        Bar = ... # type: QAbstractDataProxy.DataType
        Scatter = ... # type: QAbstractDataProxy.DataType
        Surface = ... # type: QAbstractDataProxy.DataType

    def type(self) -> 'QAbstractDataProxy.DataType': ...


class QLegendData(PyQt6.sip.simplewrapper):

    borderColor = ... # type: QtGui.QColor|QtCore.Qt.GlobalColor|int
    color = ... # type: QtGui.QColor|QtCore.Qt.GlobalColor|int
    label = ... # type: str|None

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QLegendData') -> None: ...


class QAbstractSeries(QtCore.QObject, QtQml.QQmlParserStatus):

    class SeriesType(enum.Enum):
        Line = ... # type: QAbstractSeries.SeriesType
        Area = ... # type: QAbstractSeries.SeriesType
        Bar = ... # type: QAbstractSeries.SeriesType
        Pie = ... # type: QAbstractSeries.SeriesType
        Scatter = ... # type: QAbstractSeries.SeriesType
        Spline = ... # type: QAbstractSeries.SeriesType

    zValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisYChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisXChanged: typing.ClassVar[QtCore.pyqtSignal]
    hoveredChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setZValue(self, newDrawOrder: int) -> None: ...
    def zValue(self) -> int: ...
    def setAxisY(self, newAxisY: QAbstractAxis|None) -> None: ...
    def axisY(self) -> QAbstractAxis|None: ...
    def setAxisX(self, newAxisX: QAbstractAxis|None) -> None: ...
    def axisX(self) -> QAbstractAxis|None: ...
    def setHovered(self, enabled: bool) -> None: ...
    def isHovered(self) -> bool: ...
    hover: typing.ClassVar[QtCore.pyqtSignal]
    hoverExit: typing.ClassVar[QtCore.pyqtSignal]
    hoverEnter: typing.ClassVar[QtCore.pyqtSignal]
    legendDataChanged: typing.ClassVar[QtCore.pyqtSignal]
    valuesMultiplierChanged: typing.ClassVar[QtCore.pyqtSignal]
    opacityChanged: typing.ClassVar[QtCore.pyqtSignal]
    hoverableChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectableChanged: typing.ClassVar[QtCore.pyqtSignal]
    visibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    nameChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setHoverable(self, newHoverable: bool) -> None: ...
    def isHoverable(self) -> bool: ...
    def hide(self) -> None: ...
    def show(self) -> None: ...
    def legendData(self) -> list[QLegendData]: ...
    def setValuesMultiplier(self, valuesMultiplier: float) -> None: ...
    def valuesMultiplier(self) -> float: ...
    def setOpacity(self, opacity: float) -> None: ...
    def opacity(self) -> float: ...
    def setSelectable(self, selectable: bool) -> None: ...
    def isSelectable(self) -> bool: ...
    def setVisible(self, visible: bool = ...) -> None: ...
    def isVisible(self) -> bool: ...
    def setName(self, name: str|None) -> None: ...
    def name(self) -> str: ...
    def type(self) -> 'QAbstractSeries.SeriesType': ...
    def componentComplete(self) -> None: ...
    def classBegin(self) -> None: ...


class QAreaSeries(QAbstractSeries):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    released: typing.ClassVar[QtCore.pyqtSignal]
    pressed: typing.ClassVar[QtCore.pyqtSignal]
    doubleClicked: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    lowerSeriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    upperSeriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderWidthChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedBorderColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setLowerSeries(self, newLowerSeries: 'QXYSeries|None') -> None: ...
    def lowerSeries(self) -> 'QXYSeries|None': ...
    def setUpperSeries(self, newUpperSeries: 'QXYSeries|None') -> None: ...
    def upperSeries(self) -> 'QXYSeries|None': ...
    def setSelected(self, newSelected: bool) -> None: ...
    def isSelected(self) -> bool: ...
    def setBorderWidth(self, newBorderWidth: float) -> None: ...
    def borderWidth(self) -> float: ...
    def setSelectedBorderColor(self, newSelectedBorderColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def selectedBorderColor(self) -> QtGui.QColor: ...
    def setBorderColor(self, newBorderColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def borderColor(self) -> QtGui.QColor: ...
    def setSelectedColor(self, newColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def selectedColor(self) -> QtGui.QColor: ...
    def setColor(self, newColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def type(self) -> QAbstractSeries.SeriesType: ...


class QBar3DSeries(QAbstract3DSeries):

    @typing.overload
    def __init__(self, dataProxy: 'QBarDataProxy|None', parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    valueColoringEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setValueColoringEnabled(self, enabled: bool) -> None: ...
    def isValueColoringEnabled(self) -> bool: ...
    dataArrayChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnLabelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowLabelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowColorsChanged: typing.ClassVar[QtCore.pyqtSignal]
    meshAngleChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedBarChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataProxyChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setColumnLabels(self, labels: collections.abc.Iterable[str|None]) -> None: ...
    def columnLabels(self) -> list[str]: ...
    def setRowLabels(self, labels: collections.abc.Iterable[str|None]) -> None: ...
    def rowLabels(self) -> list[str]: ...
    def dataArray(self) -> list[list['QBarDataItem']]: ...
    def clearArray(self) -> None: ...
    def clearRow(self, rowIndex: int) -> None: ...
    def setDataArray(self, newDataArray: collections.abc.Iterable[collections.abc.Iterable['QBarDataItem']]) -> None: ...
    def setRowColors(self, colors: collections.abc.Iterable[QtGui.QColor|QtCore.Qt.GlobalColor|int]) -> None: ...
    def rowColors(self) -> list[QtGui.QColor]: ...
    def meshAngle(self) -> float: ...
    def setMeshAngle(self, angle: float) -> None: ...
    @staticmethod
    def invalidSelectionPosition() -> QtCore.QPoint: ...
    def selectedBar(self) -> QtCore.QPoint: ...
    def setSelectedBar(self, position: QtCore.QPoint) -> None: ...
    def dataProxy(self) -> 'QBarDataProxy|None': ...
    def setDataProxy(self, proxy: 'QBarDataProxy|None') -> None: ...


class QBarCategoryAxis(QAbstractAxis):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    countChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxChanged: typing.ClassVar[QtCore.pyqtSignal]
    minChanged: typing.ClassVar[QtCore.pyqtSignal]
    categoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setRange(self, minCategory: str|None, maxCategory: str|None) -> None: ...
    def max(self) -> str: ...
    def setMax(self, maxCategory: str|None) -> None: ...
    def min(self) -> str: ...
    def setMin(self, minCategory: str|None) -> None: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def categories(self) -> list[str]: ...
    def setCategories(self, categories: collections.abc.Iterable[str|None]) -> None: ...
    def at(self, index: int) -> str: ...
    def clear(self) -> None: ...
    def replace(self, oldCategory: str|None, newCategory: str|None) -> None: ...
    def insert(self, index: int, category: str|None) -> None: ...
    @typing.overload
    def remove(self, category: str|None) -> None: ...
    @typing.overload
    def remove(self, index: int) -> None: ...
    @typing.overload
    def append(self, categories: collections.abc.Iterable[str|None]) -> None: ...
    @typing.overload
    def append(self, category: str|None) -> None: ...
    def type(self) -> QAbstractAxis.AxisType: ...


class QBarDataItem(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, value: float) -> None: ...
    @typing.overload
    def __init__(self, value: float, angle: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QBarDataItem') -> None: ...

    def rotation(self) -> float: ...
    def setRotation(self, angle: float) -> None: ...
    def value(self) -> float: ...
    def setValue(self, val: float) -> None: ...


class QBarDataProxy(QAbstractDataProxy):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    seriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    colCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowsInserted: typing.ClassVar[QtCore.pyqtSignal]
    rowsRemoved: typing.ClassVar[QtCore.pyqtSignal]
    rowsChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowsAdded: typing.ClassVar[QtCore.pyqtSignal]
    arrayReset: typing.ClassVar[QtCore.pyqtSignal]
    def removeRows(self, rowIndex: int, removeCount: int, removeLabels: bool = ...) -> None: ...
    @typing.overload
    def insertRows(self, rowIndex: int, rows: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]]) -> None: ...
    @typing.overload
    def insertRows(self, rowIndex: int, rows: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]], labels: collections.abc.Iterable[str|None]) -> None: ...
    @typing.overload
    def insertRow(self, rowIndex: int, row: collections.abc.Iterable[QBarDataItem]) -> None: ...
    @typing.overload
    def insertRow(self, rowIndex: int, row: collections.abc.Iterable[QBarDataItem], label: str|None) -> None: ...
    @typing.overload
    def addRows(self, rows: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]]) -> int: ...
    @typing.overload
    def addRows(self, rows: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]], labels: collections.abc.Iterable[str|None]) -> int: ...
    @typing.overload
    def addRow(self, row: collections.abc.Iterable[QBarDataItem]) -> int: ...
    @typing.overload
    def addRow(self, row: collections.abc.Iterable[QBarDataItem], label: str|None) -> int: ...
    @typing.overload
    def setItem(self, rowIndex: int, columnIndex: int, item: QBarDataItem) -> None: ...
    @typing.overload
    def setItem(self, position: QtCore.QPoint, item: QBarDataItem) -> None: ...
    @typing.overload
    def setRows(self, rowIndex: int, rows: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]]) -> None: ...
    @typing.overload
    def setRows(self, rowIndex: int, rows: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]], labels: collections.abc.Iterable[str|None]) -> None: ...
    @typing.overload
    def setRow(self, rowIndex: int, row: collections.abc.Iterable[QBarDataItem]) -> None: ...
    @typing.overload
    def setRow(self, rowIndex: int, row: collections.abc.Iterable[QBarDataItem], label: str|None) -> None: ...
    @typing.overload
    def resetArray(self) -> None: ...
    @typing.overload
    def resetArray(self, newArray: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]]) -> None: ...
    @typing.overload
    def resetArray(self, newArray: collections.abc.Iterable[collections.abc.Iterable[QBarDataItem]], rowLabels: collections.abc.Iterable[str|None], columnLabels: collections.abc.Iterable[str|None]) -> None: ...
    @typing.overload
    def itemAt(self, rowIndex: int, columnIndex: int) -> QBarDataItem: ...
    @typing.overload
    def itemAt(self, position: QtCore.QPoint) -> QBarDataItem: ...
    def rowAt(self, rowIndex: int) -> list[QBarDataItem]: ...
    def colCount(self) -> int: ...
    def rowCount(self) -> int: ...
    def series(self) -> QBar3DSeries|None: ...


class QBarModelMapper(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    orientationChanged: typing.ClassVar[QtCore.pyqtSignal]
    countChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstChanged: typing.ClassVar[QtCore.pyqtSignal]
    lastBarSetSectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstBarSetSectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    modelChanged: typing.ClassVar[QtCore.pyqtSignal]
    seriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setOrientation(self, orientation: QtCore.Qt.Orientation) -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setFirst(self, newFirst: int) -> None: ...
    def first(self) -> int: ...
    def setCount(self, newCount: int) -> None: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def setLastBarSetSection(self, newLastBarSetSection: int) -> None: ...
    def lastBarSetSection(self) -> int: ...
    def setFirstBarSetSection(self, newFirstBarSetSection: int) -> None: ...
    def firstBarSetSection(self) -> int: ...
    def setSeries(self, series: 'QBarSeries|None') -> None: ...
    def series(self) -> 'QBarSeries|None': ...
    def setModel(self, model: QtCore.QAbstractItemModel|None) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel|None: ...


class QBarSeries(QAbstractSeries):

    class BarsType(enum.Enum):
        Groups = ... # type: QBarSeries.BarsType
        Stacked = ... # type: QBarSeries.BarsType
        StackedPercent = ... # type: QBarSeries.BarsType

    class LabelsPosition(enum.Enum):
        Center = ... # type: QBarSeries.LabelsPosition
        InsideEnd = ... # type: QBarSeries.LabelsPosition
        InsideBase = ... # type: QBarSeries.LabelsPosition
        OutsideEnd = ... # type: QBarSeries.LabelsPosition

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    released: typing.ClassVar[QtCore.pyqtSignal]
    pressed: typing.ClassVar[QtCore.pyqtSignal]
    doubleClicked: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    barSetsChanged: typing.ClassVar[QtCore.pyqtSignal]
    setValueRemoved: typing.ClassVar[QtCore.pyqtSignal]
    setValueAdded: typing.ClassVar[QtCore.pyqtSignal]
    setValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    barsetsRemoved: typing.ClassVar[QtCore.pyqtSignal]
    barsetsReplaced: typing.ClassVar[QtCore.pyqtSignal]
    barsetsAdded: typing.ClassVar[QtCore.pyqtSignal]
    barDelegateChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsPrecisionChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsAngleChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsMarginChanged: typing.ClassVar[QtCore.pyqtSignal]
    barsTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    barWidthChanged: typing.ClassVar[QtCore.pyqtSignal]
    countChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderColorsChanged: typing.ClassVar[QtCore.pyqtSignal]
    seriesColorsChanged: typing.ClassVar[QtCore.pyqtSignal]
    updatedBars: typing.ClassVar[QtCore.pyqtSignal]
    def componentComplete(self) -> None: ...
    def setBarDelegate(self, newBarDelegate: QtQml.QQmlComponent|None) -> None: ...
    def barDelegate(self) -> QtQml.QQmlComponent|None: ...
    def labelsPrecision(self) -> int: ...
    def setLabelsPrecision(self, precision: int) -> None: ...
    def labelsPosition(self) -> 'QBarSeries.LabelsPosition': ...
    def setLabelsPosition(self, position: 'QBarSeries.LabelsPosition') -> None: ...
    def labelsAngle(self) -> float: ...
    def setLabelsAngle(self, angle: float) -> None: ...
    def labelsMargin(self) -> float: ...
    def setLabelsMargin(self, margin: float) -> None: ...
    def labelsFormat(self) -> str: ...
    def setLabelsFormat(self, format: str|None) -> None: ...
    def labelsVisible(self) -> bool: ...
    def setLabelsVisible(self, visible: bool = ...) -> None: ...
    def barSets(self) -> list['QBarSet']: ...
    def clear(self) -> None: ...
    def find(self, set: 'QBarSet|None') -> int: ...
    def at(self, index: int) -> 'QBarSet|None': ...
    @typing.overload
    def replace(self, index: int, set: 'QBarSet|None') -> None: ...
    @typing.overload
    def replace(self, oldValue: 'QBarSet|None', newValue: 'QBarSet|None') -> bool: ...
    @typing.overload
    def replace(self, sets: collections.abc.Iterable['QBarSet']) -> bool: ...
    def insert(self, index: int, set: 'QBarSet|None') -> bool: ...
    def removeMultiple(self, index: int, count: int) -> None: ...
    @typing.overload
    def remove(self, index: int) -> bool: ...
    @typing.overload
    def remove(self, set: 'QBarSet|None') -> bool: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def take(self, set: 'QBarSet|None') -> bool: ...
    @typing.overload
    def append(self, set: 'QBarSet|None') -> bool: ...
    @typing.overload
    def append(self, sets: collections.abc.Iterable['QBarSet']) -> bool: ...
    def barWidth(self) -> float: ...
    def setBarWidth(self, width: float) -> None: ...
    def barsType(self) -> 'QBarSeries.BarsType': ...
    def setBarsType(self, type: 'QBarSeries.BarsType') -> None: ...
    def setBorderColors(self, newBorderColors: collections.abc.Iterable[QtGui.QColor|QtCore.Qt.GlobalColor|int]) -> None: ...
    def borderColors(self) -> list[QtGui.QColor]: ...
    def setSeriesColors(self, newSeriesColors: collections.abc.Iterable[QtGui.QColor|QtCore.Qt.GlobalColor|int]) -> None: ...
    def seriesColors(self) -> list[QtGui.QColor]: ...
    def type(self) -> QAbstractSeries.SeriesType: ...


class QBarSet(QtCore.QObject):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, label: str|None, parent: QtCore.QObject|None = ...) -> None: ...

    selectedBarsChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueRemoved: typing.ClassVar[QtCore.pyqtSignal]
    valueAdded: typing.ClassVar[QtCore.pyqtSignal]
    updatedBars: typing.ClassVar[QtCore.pyqtSignal]
    valueChanged: typing.ClassVar[QtCore.pyqtSignal]
    valuesRemoved: typing.ClassVar[QtCore.pyqtSignal]
    valuesAdded: typing.ClassVar[QtCore.pyqtSignal]
    borderWidthChanged: typing.ClassVar[QtCore.pyqtSignal]
    countChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    valuesChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelChanged: typing.ClassVar[QtCore.pyqtSignal]
    update: typing.ClassVar[QtCore.pyqtSignal]
    def selectedBars(self) -> list[int]: ...
    def toggleSelection(self, indexes: collections.abc.Iterable[int]) -> None: ...
    def deselectBars(self, indexes: collections.abc.Iterable[int]) -> None: ...
    def selectBars(self, indexes: collections.abc.Iterable[int]) -> None: ...
    def deselectAllBars(self) -> None: ...
    def selectAllBars(self) -> None: ...
    def setBarSelected(self, index: int, selected: bool) -> None: ...
    def deselectBar(self, index: int) -> None: ...
    def selectBar(self, index: int) -> None: ...
    def isBarSelected(self, index: int) -> bool: ...
    def setBorderWidth(self, borderWidth: float) -> None: ...
    def borderWidth(self) -> float: ...
    def setValues(self, values: collections.abc.Iterable[typing.Any]) -> None: ...
    def values(self) -> list[typing.Any]: ...
    def setSelectedColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def selectedColor(self) -> QtGui.QColor: ...
    def setLabelColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def labelColor(self) -> QtGui.QColor: ...
    def setBorderColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def borderColor(self) -> QtGui.QColor: ...
    def setColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def __lshift__(self, value: float) -> 'QBarSet': ...
    def __getitem__(self, index: int) -> float: ...
    def clear(self) -> None: ...
    def sum(self) -> float: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def at(self, index: int) -> float: ...
    def replace(self, index: int, value: float) -> None: ...
    def remove(self, index: int, count: int = ...) -> None: ...
    def insert(self, index: int, value: float) -> None: ...
    @typing.overload
    def append(self, value: float) -> None: ...
    @typing.overload
    def append(self, values: collections.abc.Iterable[float]) -> None: ...
    def label(self) -> str: ...
    def setLabel(self, label: str|None) -> None: ...


class QCategory3DAxis(QAbstract3DAxis):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    columnLabelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowLabelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    def labels(self) -> list[str]: ...
    def setLabels(self, labels: collections.abc.Iterable[str|None]) -> None: ...


class QCustom3DItem(QtCore.QObject):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, meshFile: str|None, position: QtGui.QVector3D, scaling: QtGui.QVector3D, rotation: QtGui.QQuaternion, texture: QtGui.QImage, parent: QtCore.QObject|None = ...) -> None: ...

    scalingAbsoluteChanged: typing.ClassVar[QtCore.pyqtSignal]
    shadowCastingChanged: typing.ClassVar[QtCore.pyqtSignal]
    visibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    scalingChanged: typing.ClassVar[QtCore.pyqtSignal]
    positionAbsoluteChanged: typing.ClassVar[QtCore.pyqtSignal]
    positionChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureFileChanged: typing.ClassVar[QtCore.pyqtSignal]
    meshFileChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setTextureImage(self, textureImage: QtGui.QImage) -> None: ...
    def setRotationAxisAndAngle(self, axis: QtGui.QVector3D, angle: float) -> None: ...
    def isShadowCasting(self) -> bool: ...
    def setShadowCasting(self, enabled: bool) -> None: ...
    def isVisible(self) -> bool: ...
    def setVisible(self, visible: bool) -> None: ...
    def rotation(self) -> QtGui.QQuaternion: ...
    def setRotation(self, rotation: QtGui.QQuaternion) -> None: ...
    def isScalingAbsolute(self) -> bool: ...
    def setScalingAbsolute(self, scalingAbsolute: bool) -> None: ...
    def scaling(self) -> QtGui.QVector3D: ...
    def setScaling(self, scaling: QtGui.QVector3D) -> None: ...
    def isPositionAbsolute(self) -> bool: ...
    def setPositionAbsolute(self, positionAbsolute: bool) -> None: ...
    def position(self) -> QtGui.QVector3D: ...
    def setPosition(self, position: QtGui.QVector3D) -> None: ...
    def textureFile(self) -> str: ...
    def setTextureFile(self, textureFile: str|None) -> None: ...
    def meshFile(self) -> str: ...
    def setMeshFile(self, meshFile: str|None) -> None: ...


class QCustom3DLabel(QCustom3DItem):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str|None, font: QtGui.QFont, position: QtGui.QVector3D, scaling: QtGui.QVector3D, rotation: QtGui.QQuaternion, parent: QtCore.QObject|None = ...) -> None: ...

    facingCameraChanged: typing.ClassVar[QtCore.pyqtSignal]
    backgroundVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    backgroundColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    textColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    fontChanged: typing.ClassVar[QtCore.pyqtSignal]
    textChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isFacingCamera(self) -> bool: ...
    def setFacingCamera(self, enabled: bool) -> None: ...
    def isBackgroundVisible(self) -> bool: ...
    def setBackgroundVisible(self, visible: bool) -> None: ...
    def isBorderVisible(self) -> bool: ...
    def setBorderVisible(self, visible: bool) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setBackgroundColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def textColor(self) -> QtGui.QColor: ...
    def setTextColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def text(self) -> str: ...
    def setText(self, text: str|None) -> None: ...


class QCustom3DVolume(QCustom3DItem):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, position: QtGui.QVector3D, scaling: QtGui.QVector3D, rotation: QtGui.QQuaternion, textureWidth: int, textureHeight: int, textureDepth: int, textureData: sip.array, textureFormat: QtGui.QImage.Format, colorTable: collections.abc.Iterable[int], parent: QtCore.QObject|None = ...) -> None: ...

    sliceFrameThicknessesChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceFrameGapsChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceFrameWidthsChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceFrameColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    drawSliceFramesChanged: typing.ClassVar[QtCore.pyqtSignal]
    drawSlicesChanged: typing.ClassVar[QtCore.pyqtSignal]
    useHighDefShaderChanged: typing.ClassVar[QtCore.pyqtSignal]
    preserveOpacityChanged: typing.ClassVar[QtCore.pyqtSignal]
    alphaMultiplierChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureDataChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorTableChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceIndexZChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceIndexYChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceIndexXChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureDepthChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureHeightChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureWidthChanged: typing.ClassVar[QtCore.pyqtSignal]
    def renderSlice(self, axis: QtCore.Qt.Axis, index: int) -> QtGui.QImage: ...
    def sliceFrameThicknesses(self) -> QtGui.QVector3D: ...
    def setSliceFrameThicknesses(self, values: QtGui.QVector3D) -> None: ...
    def sliceFrameGaps(self) -> QtGui.QVector3D: ...
    def setSliceFrameGaps(self, values: QtGui.QVector3D) -> None: ...
    def sliceFrameWidths(self) -> QtGui.QVector3D: ...
    def setSliceFrameWidths(self, values: QtGui.QVector3D) -> None: ...
    def sliceFrameColor(self) -> QtGui.QColor: ...
    def setSliceFrameColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def drawSliceFrames(self) -> bool: ...
    def setDrawSliceFrames(self, enable: bool) -> None: ...
    def drawSlices(self) -> bool: ...
    def setDrawSlices(self, enable: bool) -> None: ...
    def useHighDefShader(self) -> bool: ...
    def setUseHighDefShader(self, enable: bool) -> None: ...
    def preserveOpacity(self) -> bool: ...
    def setPreserveOpacity(self, enable: bool) -> None: ...
    def alphaMultiplier(self) -> float: ...
    def setAlphaMultiplier(self, mult: float) -> None: ...
    def textureFormat(self) -> QtGui.QImage.Format: ...
    def setTextureFormat(self, format: QtGui.QImage.Format) -> None: ...
    @typing.overload
    def setSubTextureData(self, axis: QtCore.Qt.Axis, index: int, data: PyQt6.sip.voidptr) -> None: ...
    @typing.overload
    def setSubTextureData(self, axis: QtCore.Qt.Axis, index: int, image: QtGui.QImage) -> None: ...
    def textureData(self) -> sip.array: ...
    def createTextureData(self, images: collections.abc.Iterable[QtGui.QImage]) -> sip.array: ...
    def setTextureData(self, data: sip.array) -> None: ...
    def colorTable(self) -> list[int]: ...
    def setColorTable(self, colors: collections.abc.Iterable[int]) -> None: ...
    def setSliceIndices(self, x: int, y: int, z: int) -> None: ...
    def sliceIndexZ(self) -> int: ...
    def setSliceIndexZ(self, value: int) -> None: ...
    def sliceIndexY(self) -> int: ...
    def setSliceIndexY(self, value: int) -> None: ...
    def sliceIndexX(self) -> int: ...
    def setSliceIndexX(self, value: int) -> None: ...
    def textureDataWidth(self) -> int: ...
    def setTextureDimensions(self, width: int, height: int, depth: int) -> None: ...
    def textureDepth(self) -> int: ...
    def setTextureDepth(self, value: int) -> None: ...
    def textureHeight(self) -> int: ...
    def setTextureHeight(self, value: int) -> None: ...
    def textureWidth(self) -> int: ...
    def setTextureWidth(self, value: int) -> None: ...


class QDateTimeAxis(QAbstractAxis):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    subTickCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    tickIntervalChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxChanged: typing.ClassVar[QtCore.pyqtSignal]
    minChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setSubTickCount(self, newSubTickCount: int) -> None: ...
    def subTickCount(self) -> int: ...
    def setTickInterval(self, newTickInterval: float) -> None: ...
    def tickInterval(self) -> float: ...
    def labelFormat(self) -> str: ...
    def setLabelFormat(self, format: str|None) -> None: ...
    def max(self) -> QtCore.QDateTime: ...
    def setMax(self, max: QtCore.QDateTime|datetime.datetime) -> None: ...
    def min(self) -> QtCore.QDateTime: ...
    def setMin(self, min: QtCore.QDateTime|datetime.datetime) -> None: ...
    def type(self) -> QAbstractAxis.AxisType: ...


class QtGraphs3D(PyQt6.sip.simplewrapper):

    class SliceCaptureType(enum.Enum):
        NoImage = ... # type: QtGraphs3D.SliceCaptureType
        RowImage = ... # type: QtGraphs3D.SliceCaptureType
        ColumnImage = ... # type: QtGraphs3D.SliceCaptureType

    class TransparencyTechnique(enum.Enum):
        Default = ... # type: QtGraphs3D.TransparencyTechnique
        Approximate = ... # type: QtGraphs3D.TransparencyTechnique
        Accurate = ... # type: QtGraphs3D.TransparencyTechnique

    class GridLineType(enum.Enum):
        Shader = ... # type: QtGraphs3D.GridLineType
        Geometry = ... # type: QtGraphs3D.GridLineType

    class CameraPreset(enum.Enum):
        NoPreset = ... # type: QtGraphs3D.CameraPreset
        FrontLow = ... # type: QtGraphs3D.CameraPreset
        Front = ... # type: QtGraphs3D.CameraPreset
        FrontHigh = ... # type: QtGraphs3D.CameraPreset
        LeftLow = ... # type: QtGraphs3D.CameraPreset
        Left = ... # type: QtGraphs3D.CameraPreset
        LeftHigh = ... # type: QtGraphs3D.CameraPreset
        RightLow = ... # type: QtGraphs3D.CameraPreset
        Right = ... # type: QtGraphs3D.CameraPreset
        RightHigh = ... # type: QtGraphs3D.CameraPreset
        BehindLow = ... # type: QtGraphs3D.CameraPreset
        Behind = ... # type: QtGraphs3D.CameraPreset
        BehindHigh = ... # type: QtGraphs3D.CameraPreset
        IsometricLeft = ... # type: QtGraphs3D.CameraPreset
        IsometricLeftHigh = ... # type: QtGraphs3D.CameraPreset
        IsometricRight = ... # type: QtGraphs3D.CameraPreset
        IsometricRightHigh = ... # type: QtGraphs3D.CameraPreset
        DirectlyAbove = ... # type: QtGraphs3D.CameraPreset
        DirectlyAboveCW45 = ... # type: QtGraphs3D.CameraPreset
        DirectlyAboveCCW45 = ... # type: QtGraphs3D.CameraPreset
        FrontBelow = ... # type: QtGraphs3D.CameraPreset
        LeftBelow = ... # type: QtGraphs3D.CameraPreset
        RightBelow = ... # type: QtGraphs3D.CameraPreset
        BehindBelow = ... # type: QtGraphs3D.CameraPreset
        DirectlyBelow = ... # type: QtGraphs3D.CameraPreset

    class RenderingMode(enum.Enum):
        DirectToBackground = ... # type: QtGraphs3D.RenderingMode
        Indirect = ... # type: QtGraphs3D.RenderingMode

    class OptimizationHint(enum.Enum):
        Default = ... # type: QtGraphs3D.OptimizationHint
        Legacy = ... # type: QtGraphs3D.OptimizationHint

    class ElementType(enum.Enum):
        None_ = ... # type: QtGraphs3D.ElementType
        Series = ... # type: QtGraphs3D.ElementType
        AxisXLabel = ... # type: QtGraphs3D.ElementType
        AxisYLabel = ... # type: QtGraphs3D.ElementType
        AxisZLabel = ... # type: QtGraphs3D.ElementType
        CustomItem = ... # type: QtGraphs3D.ElementType

    class ShadowQuality(enum.Enum):
        None_ = ... # type: QtGraphs3D.ShadowQuality
        Low = ... # type: QtGraphs3D.ShadowQuality
        Medium = ... # type: QtGraphs3D.ShadowQuality
        High = ... # type: QtGraphs3D.ShadowQuality
        SoftLow = ... # type: QtGraphs3D.ShadowQuality
        SoftMedium = ... # type: QtGraphs3D.ShadowQuality
        SoftHigh = ... # type: QtGraphs3D.ShadowQuality

    class SelectionFlag(enum.Enum):
        None_ = ... # type: QtGraphs3D.SelectionFlag
        Item = ... # type: QtGraphs3D.SelectionFlag
        Row = ... # type: QtGraphs3D.SelectionFlag
        ItemAndRow = ... # type: QtGraphs3D.SelectionFlag
        Column = ... # type: QtGraphs3D.SelectionFlag
        ItemAndColumn = ... # type: QtGraphs3D.SelectionFlag
        RowAndColumn = ... # type: QtGraphs3D.SelectionFlag
        ItemRowAndColumn = ... # type: QtGraphs3D.SelectionFlag
        Slice = ... # type: QtGraphs3D.SelectionFlag
        MultiSeries = ... # type: QtGraphs3D.SelectionFlag


class QGraphsLine(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QGraphsLine') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def setLabelTextColor(self, newColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def labelTextColor(self) -> QtGui.QColor: ...
    def setSubWidth(self, newWidth: float) -> None: ...
    def subWidth(self) -> float: ...
    def setMainWidth(self, newWidth: float) -> None: ...
    def mainWidth(self) -> float: ...
    def setSubColor(self, newColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def subColor(self) -> QtGui.QColor: ...
    def setMainColor(self, newColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def mainColor(self) -> QtGui.QColor: ...
    def swap(self, other: 'QGraphsLine') -> None: ...


class QGraphsTheme(QtCore.QObject, QtQml.QQmlParserStatus):

    class ColorScheme(enum.Enum):
        Automatic = ... # type: QGraphsTheme.ColorScheme
        Light = ... # type: QGraphsTheme.ColorScheme
        Dark = ... # type: QGraphsTheme.ColorScheme

    class ColorStyle(enum.Enum):
        Uniform = ... # type: QGraphsTheme.ColorStyle
        ObjectGradient = ... # type: QGraphsTheme.ColorStyle
        RangeGradient = ... # type: QGraphsTheme.ColorStyle

    class Theme(enum.Enum):
        QtGreen = ... # type: QGraphsTheme.Theme
        QtGreenNeon = ... # type: QGraphsTheme.Theme
        MixSeries = ... # type: QGraphsTheme.Theme
        OrangeSeries = ... # type: QGraphsTheme.Theme
        YellowSeries = ... # type: QGraphsTheme.Theme
        BlueSeries = ... # type: QGraphsTheme.Theme
        PurpleSeries = ... # type: QGraphsTheme.Theme
        GreySeries = ... # type: QGraphsTheme.Theme
        UserDefined = ... # type: QGraphsTheme.Theme

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def componentComplete(self) -> None: ...
    def classBegin(self) -> None: ...
    axisZChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisYChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisXChanged: typing.ClassVar[QtCore.pyqtSignal]
    gridChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisZLabelFontChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisYLabelFontChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisXLabelFontChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiHighlightGradientQMLChanged: typing.ClassVar[QtCore.pyqtSignal]
    singleHighlightGradientQMLChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderWidthChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderColorsChanged: typing.ClassVar[QtCore.pyqtSignal]
    seriesGradientsChanged: typing.ClassVar[QtCore.pyqtSignal]
    seriesColorsChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelBorderVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelBackgroundVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelFontChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiHighlightGradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    singleHighlightGradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiHighlightColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    singleHighlightColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelTextColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelBackgroundColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    gridVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    plotAreaBackgroundVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    plotAreaBackgroundColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    backgroundVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    backgroundColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorStyleChanged: typing.ClassVar[QtCore.pyqtSignal]
    themeChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorSchemeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setAxisZ(self, newAxisZ: QGraphsLine) -> None: ...
    def axisZ(self) -> QGraphsLine: ...
    def setAxisY(self, newAxisY: QGraphsLine) -> None: ...
    def axisY(self) -> QGraphsLine: ...
    def setAxisX(self, newAxisX: QGraphsLine) -> None: ...
    def axisX(self) -> QGraphsLine: ...
    def setGrid(self, newGrid: QGraphsLine) -> None: ...
    def grid(self) -> QGraphsLine: ...
    def setAxisZLabelFont(self, newAxisZLabelFont: QtGui.QFont) -> None: ...
    def axisZLabelFont(self) -> QtGui.QFont: ...
    def setAxisYLabelFont(self, newAxisYLabelFont: QtGui.QFont) -> None: ...
    def axisYLabelFont(self) -> QtGui.QFont: ...
    def setAxisXLabelFont(self, newAxisXLabelFont: QtGui.QFont) -> None: ...
    def axisXLabelFont(self) -> QtGui.QFont: ...
    def setBorderWidth(self, newBorderWidth: float) -> None: ...
    def borderWidth(self) -> float: ...
    def setLabelBorderVisible(self, newLabelBorderVisibility: bool) -> None: ...
    def isLabelBorderVisible(self) -> bool: ...
    def setLabelBackgroundVisible(self, newLabelBackgroundVisibility: bool) -> None: ...
    def isLabelBackgroundVisible(self) -> bool: ...
    def setSeriesGradients(self, newSeriesGradients: collections.abc.Iterable[QtGui.QLinearGradient]) -> None: ...
    def seriesGradients(self) -> list[QtGui.QLinearGradient]: ...
    def setBorderColors(self, newBorderColors: collections.abc.Iterable[QtGui.QColor|QtCore.Qt.GlobalColor|int]) -> None: ...
    def borderColors(self) -> list[QtGui.QColor]: ...
    def setSeriesColors(self, newSeriesColors: collections.abc.Iterable[QtGui.QColor|QtCore.Qt.GlobalColor|int]) -> None: ...
    def seriesColors(self) -> list[QtGui.QColor]: ...
    def setLabelFont(self, newFont: QtGui.QFont) -> None: ...
    def labelFont(self) -> QtGui.QFont: ...
    def multiHighlightGradient(self) -> QtGui.QLinearGradient: ...
    def setMultiHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def singleHighlightGradient(self) -> QtGui.QLinearGradient: ...
    def setSingleHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def setMultiHighlightColor(self, newMultiHighlightColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def multiHighlightColor(self) -> QtGui.QColor: ...
    def setSingleHighlightColor(self, newSingleHighlightColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def singleHighlightColor(self) -> QtGui.QColor: ...
    def setLabelTextColor(self, newLabelTextColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def labelTextColor(self) -> QtGui.QColor: ...
    def setLabelBackgroundColor(self, newLabelBackgroundColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def labelBackgroundColor(self) -> QtGui.QColor: ...
    def setLabelsVisible(self, newLabelsVisibility: bool) -> None: ...
    def labelsVisible(self) -> bool: ...
    def setGridVisible(self, newGridVisibility: bool) -> None: ...
    def isGridVisible(self) -> bool: ...
    def setPlotAreaBackgroundVisible(self, newBackgroundVisibility: bool) -> None: ...
    def isPlotAreaBackgroundVisible(self) -> bool: ...
    def setPlotAreaBackgroundColor(self, newBackgroundColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def plotAreaBackgroundColor(self) -> QtGui.QColor: ...
    def setBackgroundVisible(self, newBackgroundVisible: bool) -> None: ...
    def isBackgroundVisible(self) -> bool: ...
    def setBackgroundColor(self, newBackgroundColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setColorStyle(self, newColorStyle: 'QGraphsTheme.ColorStyle') -> None: ...
    def colorStyle(self) -> 'QGraphsTheme.ColorStyle': ...
    def setTheme(self, newTheme: 'QGraphsTheme.Theme', force: bool = ...) -> None: ...
    def theme(self) -> 'QGraphsTheme.Theme': ...
    def setColorScheme(self, newColorScheme: 'QGraphsTheme.ColorScheme') -> None: ...
    def colorScheme(self) -> 'QGraphsTheme.ColorScheme': ...


class QSurfaceDataProxy(QAbstractDataProxy):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    seriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowsInserted: typing.ClassVar[QtCore.pyqtSignal]
    rowsRemoved: typing.ClassVar[QtCore.pyqtSignal]
    rowsChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowsAdded: typing.ClassVar[QtCore.pyqtSignal]
    arrayReset: typing.ClassVar[QtCore.pyqtSignal]
    def removeRows(self, rowIndex: int, removeCount: int) -> None: ...
    def insertRows(self, rowIndex: int, rows: collections.abc.Iterable[collections.abc.Iterable['QSurfaceDataItem']]) -> None: ...
    def insertRow(self, rowIndex: int, row: collections.abc.Iterable['QSurfaceDataItem']) -> None: ...
    def addRows(self, rows: collections.abc.Iterable[collections.abc.Iterable['QSurfaceDataItem']]) -> int: ...
    def addRow(self, row: collections.abc.Iterable['QSurfaceDataItem']) -> int: ...
    @typing.overload
    def setItem(self, rowIndex: int, columnIndex: int, item: 'QSurfaceDataItem') -> None: ...
    @typing.overload
    def setItem(self, position: QtCore.QPoint, item: 'QSurfaceDataItem') -> None: ...
    def setRows(self, rowIndex: int, rows: collections.abc.Iterable[collections.abc.Iterable['QSurfaceDataItem']]) -> None: ...
    def setRow(self, rowIndex: int, row: collections.abc.Iterable['QSurfaceDataItem']) -> None: ...
    @typing.overload
    def resetArray(self) -> None: ...
    @typing.overload
    def resetArray(self, newArray: collections.abc.Iterable[collections.abc.Iterable['QSurfaceDataItem']]) -> None: ...
    @typing.overload
    def itemAt(self, rowIndex: int, columnIndex: int) -> 'QSurfaceDataItem': ...
    @typing.overload
    def itemAt(self, position: QtCore.QPoint) -> 'QSurfaceDataItem': ...
    def columnCount(self) -> int: ...
    def rowCount(self) -> int: ...
    def series(self) -> 'QSurface3DSeries|None': ...


class QHeightMapSurfaceDataProxy(QSurfaceDataProxy):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, image: QtGui.QImage, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, filename: str|None, parent: QtCore.QObject|None = ...) -> None: ...

    autoScaleYChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxYValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    minYValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxZValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    minZValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxXValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    minXValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    heightMapFileChanged: typing.ClassVar[QtCore.pyqtSignal]
    heightMapChanged: typing.ClassVar[QtCore.pyqtSignal]
    def autoScaleY(self) -> bool: ...
    def setAutoScaleY(self, enabled: bool) -> None: ...
    def maxYValue(self) -> float: ...
    def setMaxYValue(self, max: float) -> None: ...
    def minYValue(self) -> float: ...
    def setMinYValue(self, min: float) -> None: ...
    def maxZValue(self) -> float: ...
    def setMaxZValue(self, max: float) -> None: ...
    def minZValue(self) -> float: ...
    def setMinZValue(self, min: float) -> None: ...
    def maxXValue(self) -> float: ...
    def setMaxXValue(self, max: float) -> None: ...
    def minXValue(self) -> float: ...
    def setMinXValue(self, min: float) -> None: ...
    def setValueRanges(self, minX: float, maxX: float, minZ: float, maxZ: float) -> None: ...
    def heightMapFile(self) -> str: ...
    def setHeightMapFile(self, filename: str|None) -> None: ...
    def heightMap(self) -> QtGui.QImage: ...
    def setHeightMap(self, image: QtGui.QImage) -> None: ...


class QItemModelBarDataProxy(QBarDataProxy):

    class MultiMatchBehavior(enum.Enum):
        First = ... # type: QItemModelBarDataProxy.MultiMatchBehavior
        Last = ... # type: QItemModelBarDataProxy.MultiMatchBehavior
        Average = ... # type: QItemModelBarDataProxy.MultiMatchBehavior
        Cumulative = ... # type: QItemModelBarDataProxy.MultiMatchBehavior

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, valueRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, valueRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, valueRole: str|None, rotationRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, valueRole: str|None, rowCategories: collections.abc.Iterable[str|None], columnCategories: collections.abc.Iterable[str|None], parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, valueRole: str|None, rotationRole: str|None, rowCategories: collections.abc.Iterable[str|None], columnCategories: collections.abc.Iterable[str|None], parent: QtCore.QObject|None = ...) -> None: ...

    multiMatchBehaviorChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    autoColumnCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    autoRowCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    useModelCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemModelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def multiMatchBehavior(self) -> 'QItemModelBarDataProxy.MultiMatchBehavior': ...
    def setMultiMatchBehavior(self, behavior: 'QItemModelBarDataProxy.MultiMatchBehavior') -> None: ...
    def rotationRoleReplace(self) -> str: ...
    def setRotationRoleReplace(self, replace: str|None) -> None: ...
    def valueRoleReplace(self) -> str: ...
    def setValueRoleReplace(self, replace: str|None) -> None: ...
    def columnRoleReplace(self) -> str: ...
    def setColumnRoleReplace(self, replace: str|None) -> None: ...
    def rowRoleReplace(self) -> str: ...
    def setRowRoleReplace(self, replace: str|None) -> None: ...
    def rotationRolePattern(self) -> QtCore.QRegularExpression: ...
    def setRotationRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def valueRolePattern(self) -> QtCore.QRegularExpression: ...
    def setValueRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def columnRolePattern(self) -> QtCore.QRegularExpression: ...
    def setColumnRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def rowRolePattern(self) -> QtCore.QRegularExpression: ...
    def setRowRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def columnCategoryIndex(self, category: str|None) -> int: ...
    def rowCategoryIndex(self, category: str|None) -> int: ...
    def remap(self, rowRole: str|None, columnRole: str|None, valueRole: str|None, rotationRole: str|None, rowCategories: collections.abc.Iterable[str|None], columnCategories: collections.abc.Iterable[str|None]) -> None: ...
    def autoColumnCategories(self) -> bool: ...
    def setAutoColumnCategories(self, enable: bool) -> None: ...
    def autoRowCategories(self) -> bool: ...
    def setAutoRowCategories(self, enable: bool) -> None: ...
    def useModelCategories(self) -> bool: ...
    def setUseModelCategories(self, enable: bool) -> None: ...
    def columnCategories(self) -> list[str]: ...
    def setColumnCategories(self, categories: collections.abc.Iterable[str|None]) -> None: ...
    def rowCategories(self) -> list[str]: ...
    def setRowCategories(self, categories: collections.abc.Iterable[str|None]) -> None: ...
    def rotationRole(self) -> str: ...
    def setRotationRole(self, role: str|None) -> None: ...
    def valueRole(self) -> str: ...
    def setValueRole(self, role: str|None) -> None: ...
    def columnRole(self) -> str: ...
    def setColumnRole(self, role: str|None) -> None: ...
    def rowRole(self) -> str: ...
    def setRowRole(self, role: str|None) -> None: ...
    def itemModel(self) -> QtCore.QAbstractItemModel|None: ...
    def setItemModel(self, itemModel: QtCore.QAbstractItemModel|None) -> None: ...


class QScatterDataProxy(QAbstractDataProxy):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    scaleArrayReset: typing.ClassVar[QtCore.pyqtSignal]
    def resetScaleArray(self, newArray: collections.abc.Iterable[QtGui.QVector3D]) -> None: ...
    def scaleAt(self, index: int) -> QtGui.QVector3D: ...
    seriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemsInserted: typing.ClassVar[QtCore.pyqtSignal]
    itemsRemoved: typing.ClassVar[QtCore.pyqtSignal]
    itemsChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemsAdded: typing.ClassVar[QtCore.pyqtSignal]
    arrayReset: typing.ClassVar[QtCore.pyqtSignal]
    def removeItems(self, index: int, removeCount: int) -> None: ...
    def insertItems(self, index: int, items: collections.abc.Iterable['QScatterDataItem']) -> None: ...
    def insertItem(self, index: int, item: 'QScatterDataItem') -> None: ...
    def addItems(self, items: collections.abc.Iterable['QScatterDataItem']) -> int: ...
    def addItem(self, item: 'QScatterDataItem') -> int: ...
    def setItems(self, index: int, items: collections.abc.Iterable['QScatterDataItem']) -> None: ...
    def setItem(self, index: int, item: 'QScatterDataItem') -> None: ...
    @typing.overload
    def resetArray(self) -> None: ...
    @typing.overload
    def resetArray(self, newArray: collections.abc.Iterable['QScatterDataItem']) -> None: ...
    def itemAt(self, index: int) -> 'QScatterDataItem': ...
    def itemCount(self) -> int: ...
    def series(self) -> 'QScatter3DSeries|None': ...


class QItemModelScatterDataProxy(QScatterDataProxy):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, xPosRole: str|None, yPosRole: str|None, zPosRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, xPosRole: str|None, yPosRole: str|None, zPosRole: str|None, rotationRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...

    scaleRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    scaleRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    scaleRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    def scaleRoleReplace(self) -> str: ...
    def setScaleRoleReplace(self, replace: str|None) -> None: ...
    def scaleRolePattern(self) -> QtCore.QRegularExpression: ...
    def setScaleRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def scaleRole(self) -> str: ...
    def setScaleRole(self, role: str|None) -> None: ...
    zPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    zPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    zPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemModelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def rotationRoleReplace(self) -> str: ...
    def setRotationRoleReplace(self, replace: str|None) -> None: ...
    def zPosRoleReplace(self) -> str: ...
    def setZPosRoleReplace(self, replace: str|None) -> None: ...
    def yPosRoleReplace(self) -> str: ...
    def setYPosRoleReplace(self, replace: str|None) -> None: ...
    def xPosRoleReplace(self) -> str: ...
    def setXPosRoleReplace(self, replace: str|None) -> None: ...
    def rotationRolePattern(self) -> QtCore.QRegularExpression: ...
    def setRotationRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def zPosRolePattern(self) -> QtCore.QRegularExpression: ...
    def setZPosRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def yPosRolePattern(self) -> QtCore.QRegularExpression: ...
    def setYPosRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def xPosRolePattern(self) -> QtCore.QRegularExpression: ...
    def setXPosRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    @typing.overload
    def remap(self, xPosRole: str|None, yPosRole: str|None, zPosRole: str|None, rotationRole: str|None) -> None: ...
    @typing.overload
    def remap(self, xPosRole: str|None, yPosRole: str|None, zPosRole: str|None, rotationRole: str|None, scaleRole: str|None) -> None: ...
    def rotationRole(self) -> str: ...
    def setRotationRole(self, role: str|None) -> None: ...
    def zPosRole(self) -> str: ...
    def setZPosRole(self, role: str|None) -> None: ...
    def yPosRole(self) -> str: ...
    def setYPosRole(self, role: str|None) -> None: ...
    def xPosRole(self) -> str: ...
    def setXPosRole(self, role: str|None) -> None: ...
    def itemModel(self) -> QtCore.QAbstractItemModel|None: ...
    def setItemModel(self, itemModel: QtCore.QAbstractItemModel|None) -> None: ...


class QItemModelSurfaceDataProxy(QSurfaceDataProxy):

    class MultiMatchBehavior(enum.Enum):
        First = ... # type: QItemModelSurfaceDataProxy.MultiMatchBehavior
        Last = ... # type: QItemModelSurfaceDataProxy.MultiMatchBehavior
        Average = ... # type: QItemModelSurfaceDataProxy.MultiMatchBehavior
        CumulativeY = ... # type: QItemModelSurfaceDataProxy.MultiMatchBehavior

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, yPosRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, yPosRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, xPosRole: str|None, yPosRole: str|None, zPosRole: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, yPosRole: str|None, rowCategories: collections.abc.Iterable[str|None], columnCategories: collections.abc.Iterable[str|None], parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: QtCore.QAbstractItemModel|None, rowRole: str|None, columnRole: str|None, xPosRole: str|None, yPosRole: str|None, zPosRole: str|None, rowCategories: collections.abc.Iterable[str|None], columnCategories: collections.abc.Iterable[str|None], parent: QtCore.QObject|None = ...) -> None: ...

    multiMatchBehaviorChanged: typing.ClassVar[QtCore.pyqtSignal]
    zPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    zPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    autoColumnCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    autoRowCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    useModelCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    zPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemModelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def multiMatchBehavior(self) -> 'QItemModelSurfaceDataProxy.MultiMatchBehavior': ...
    def setMultiMatchBehavior(self, behavior: 'QItemModelSurfaceDataProxy.MultiMatchBehavior') -> None: ...
    def zPosRoleReplace(self) -> str: ...
    def setZPosRoleReplace(self, replace: str|None) -> None: ...
    def yPosRoleReplace(self) -> str: ...
    def setYPosRoleReplace(self, replace: str|None) -> None: ...
    def xPosRoleReplace(self) -> str: ...
    def setXPosRoleReplace(self, replace: str|None) -> None: ...
    def columnRoleReplace(self) -> str: ...
    def setColumnRoleReplace(self, replace: str|None) -> None: ...
    def rowRoleReplace(self) -> str: ...
    def setRowRoleReplace(self, replace: str|None) -> None: ...
    def zPosRolePattern(self) -> QtCore.QRegularExpression: ...
    def setZPosRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def yPosRolePattern(self) -> QtCore.QRegularExpression: ...
    def setYPosRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def xPosRolePattern(self) -> QtCore.QRegularExpression: ...
    def setXPosRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def columnRolePattern(self) -> QtCore.QRegularExpression: ...
    def setColumnRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def rowRolePattern(self) -> QtCore.QRegularExpression: ...
    def setRowRolePattern(self, pattern: QtCore.QRegularExpression) -> None: ...
    def columnCategoryIndex(self, category: str|None) -> int: ...
    def rowCategoryIndex(self, category: str|None) -> int: ...
    def remap(self, rowRole: str|None, columnRole: str|None, xPosRole: str|None, yPosRole: str|None, zPosRole: str|None, rowCategories: collections.abc.Iterable[str|None], columnCategories: collections.abc.Iterable[str|None]) -> None: ...
    def autoColumnCategories(self) -> bool: ...
    def setAutoColumnCategories(self, enable: bool) -> None: ...
    def autoRowCategories(self) -> bool: ...
    def setAutoRowCategories(self, enable: bool) -> None: ...
    def useModelCategories(self) -> bool: ...
    def setUseModelCategories(self, enable: bool) -> None: ...
    def columnCategories(self) -> list[str]: ...
    def setColumnCategories(self, categories: collections.abc.Iterable[str|None]) -> None: ...
    def rowCategories(self) -> list[str]: ...
    def setRowCategories(self, categories: collections.abc.Iterable[str|None]) -> None: ...
    def zPosRole(self) -> str: ...
    def setZPosRole(self, role: str|None) -> None: ...
    def yPosRole(self) -> str: ...
    def setYPosRole(self, role: str|None) -> None: ...
    def xPosRole(self) -> str: ...
    def setXPosRole(self, role: str|None) -> None: ...
    def columnRole(self) -> str: ...
    def setColumnRole(self, role: str|None) -> None: ...
    def rowRole(self) -> str: ...
    def setRowRole(self, role: str|None) -> None: ...
    def itemModel(self) -> QtCore.QAbstractItemModel|None: ...
    def setItemModel(self, itemModel: QtCore.QAbstractItemModel|None) -> None: ...


class QXYSeries(QAbstractSeries):

    released: typing.ClassVar[QtCore.pyqtSignal]
    pressed: typing.ClassVar[QtCore.pyqtSignal]
    doubleClicked: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    pointsAdded: typing.ClassVar[QtCore.pyqtSignal]
    countChanged: typing.ClassVar[QtCore.pyqtSignal]
    draggableChanged: typing.ClassVar[QtCore.pyqtSignal]
    pointDelegateChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedPointsChanged: typing.ClassVar[QtCore.pyqtSignal]
    pointsReplaced: typing.ClassVar[QtCore.pyqtSignal]
    selectedColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorChanged: typing.ClassVar[QtCore.pyqtSignal]
    pointReplaced: typing.ClassVar[QtCore.pyqtSignal]
    def setDraggable(self, newDraggable: bool) -> None: ...
    def isDraggable(self) -> bool: ...
    def setPointDelegate(self, newPointDelegate: QtQml.QQmlComponent|None) -> None: ...
    def pointDelegate(self) -> QtQml.QQmlComponent|None: ...
    def selectedPoints(self) -> list[int]: ...
    def toggleSelection(self, indexes: collections.abc.Iterable[int]) -> None: ...
    def deselectPoints(self, indexes: collections.abc.Iterable[int]) -> None: ...
    def selectPoints(self, indexes: collections.abc.Iterable[int]) -> None: ...
    def deselectAllPoints(self) -> None: ...
    def selectAllPoints(self) -> None: ...
    def setPointSelected(self, index: int, selected: bool) -> None: ...
    def deselectPoint(self, index: int) -> None: ...
    def selectPoint(self, index: int) -> None: ...
    def isPointSelected(self, index: int) -> bool: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def selectedColor(self) -> QtGui.QColor: ...
    def setSelectedColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setColor(self, newColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def points(self) -> list[QtCore.QPointF]: ...
    def take(self, point: QtCore.QPointF) -> bool: ...
    def removeMultiple(self, index: int, count: int) -> None: ...
    def find(self, point: QtCore.QPointF) -> int: ...
    def at(self, index: int) -> QtCore.QPointF: ...
    def clear(self) -> None: ...
    def insert(self, index: int, point: QtCore.QPointF) -> None: ...
    @typing.overload
    def remove(self, x: float, y: float) -> None: ...
    @typing.overload
    def remove(self, point: QtCore.QPointF) -> None: ...
    @typing.overload
    def remove(self, index: int) -> None: ...
    @typing.overload
    def replace(self, oldX: float, oldY: float, newX: float, newY: float) -> None: ...
    @typing.overload
    def replace(self, oldPoint: QtCore.QPointF, newPoint: QtCore.QPointF) -> None: ...
    @typing.overload
    def replace(self, index: int, newX: float, newY: float) -> None: ...
    @typing.overload
    def replace(self, index: int, newPoint: QtCore.QPointF) -> None: ...
    @typing.overload
    def replace(self, points: collections.abc.Iterable[QtCore.QPointF]) -> None: ...
    @typing.overload
    def append(self, x: float, y: float) -> None: ...
    @typing.overload
    def append(self, point: QtCore.QPointF) -> None: ...
    @typing.overload
    def append(self, points: collections.abc.Iterable[QtCore.QPointF]) -> None: ...


class QLineSeries(QXYSeries):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def componentComplete(self) -> None: ...
    capStyleChanged: typing.ClassVar[QtCore.pyqtSignal]
    widthChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setCapStyle(self, newCapStyle: QtCore.Qt.PenCapStyle) -> None: ...
    def capStyle(self) -> QtCore.Qt.PenCapStyle: ...
    def setWidth(self, newWidth: float) -> None: ...
    def width(self) -> float: ...
    def dataPointCoordinatesAt(self, x: float, y: float) -> QtCore.QPointF: ...
    def type(self) -> QAbstractSeries.SeriesType: ...


class QValue3DAxisFormatter(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def locale(self) -> QtCore.QLocale: ...
    def setLocale(self, locale: QtCore.QLocale) -> None: ...
    def setLabelStrings(self, labelStrings: collections.abc.Iterable[str|None]) -> None: ...
    def labelStrings(self) -> list[str]: ...
    def setlabelPositions(self, labelPositions: collections.abc.Iterable[float]) -> None: ...
    def labelPositions(self) -> list[float]: ...
    def setSubGridPositions(self, subGridPositions: collections.abc.Iterable[float]) -> None: ...
    def subGridPositions(self) -> list[float]: ...
    def setGridPoitions(self, gridPositions: collections.abc.Iterable[float]) -> None: ...
    def gridPositions(self) -> list[float]: ...
    def axis(self) -> 'QValue3DAxis|None': ...
    def markDirty(self, labelsChange: bool = ...) -> None: ...
    def populateCopy(self, copy: 'QValue3DAxisFormatter') -> None: ...
    def valueAt(self, position: float) -> float: ...
    def positionAt(self, value: float) -> float: ...
    def stringForValue(self, value: float, format: str|None) -> str: ...
    def recalculate(self) -> None: ...
    def createNewInstance(self) -> 'QValue3DAxisFormatter|None': ...
    def allowZero(self) -> bool: ...
    def setAllowZero(self, allow: bool) -> None: ...
    def allowNegatives(self) -> bool: ...
    def setAllowNegatives(self, allow: bool) -> None: ...


class QLogValue3DAxisFormatter(QValue3DAxisFormatter):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def populateCopy(self, copy: QValue3DAxisFormatter) -> None: ...
    def valueAt(self, position: float) -> float: ...
    def positionAt(self, value: float) -> float: ...
    def recalculate(self) -> None: ...
    def createNewInstance(self) -> QValue3DAxisFormatter|None: ...
    edgeLabelsVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    autoSubGridChanged: typing.ClassVar[QtCore.pyqtSignal]
    baseChanged: typing.ClassVar[QtCore.pyqtSignal]
    def edgeLabelsVisible(self) -> bool: ...
    def setEdgeLabelsVisible(self, enabled: bool) -> None: ...
    def autoSubGrid(self) -> bool: ...
    def setAutoSubGrid(self, enabled: bool) -> None: ...
    def base(self) -> float: ...
    def setBase(self, base: float) -> None: ...


class QPieModelMapper(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    orientationChanged: typing.ClassVar[QtCore.pyqtSignal]
    countChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsSectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    valuesSectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    modelChanged: typing.ClassVar[QtCore.pyqtSignal]
    seriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setModel(self, model: QtCore.QAbstractItemModel|None) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel|None: ...
    def setOrientation(self, orientation: QtCore.Qt.Orientation) -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setLabelsSection(self, labelsSection: int) -> None: ...
    def labelsSection(self) -> int: ...
    def setValuesSection(self, valuesSection: int) -> None: ...
    def valuesSection(self) -> int: ...
    def setCount(self, count: int) -> None: ...
    def count(self) -> int: ...
    def setFirst(self, first: int) -> None: ...
    def first(self) -> int: ...
    def setSeries(self, series: 'QPieSeries|None') -> None: ...
    def series(self) -> 'QPieSeries|None': ...


class QPieSeries(QAbstractSeries):

    class LabelVisibility(enum.Enum):
        None_ = ... # type: QPieSeries.LabelVisibility
        First = ... # type: QPieSeries.LabelVisibility
        Even = ... # type: QPieSeries.LabelVisibility
        Odd = ... # type: QPieSeries.LabelVisibility

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    angleSpanLabelVisibilityChanged: typing.ClassVar[QtCore.pyqtSignal]
    angleSpanVisibleLimitChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setAngleSpanLabelVisibility(self, newAngleSpanVisibleMode: 'QPieSeries.LabelVisibility') -> None: ...
    def angleSpanLabelVisibility(self) -> 'QPieSeries.LabelVisibility': ...
    def setAngleSpanVisibleLimit(self, newAngleSpanVisibleLimit: float) -> None: ...
    def angleSpanVisibleLimit(self) -> float: ...
    released: typing.ClassVar[QtCore.pyqtSignal]
    pressed: typing.ClassVar[QtCore.pyqtSignal]
    doubleClicked: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    holeSizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    verticalPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    horizontalPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    endAngleChanged: typing.ClassVar[QtCore.pyqtSignal]
    startAngleChanged: typing.ClassVar[QtCore.pyqtSignal]
    pieSizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    sumChanged: typing.ClassVar[QtCore.pyqtSignal]
    countChanged: typing.ClassVar[QtCore.pyqtSignal]
    replaced: typing.ClassVar[QtCore.pyqtSignal]
    removed: typing.ClassVar[QtCore.pyqtSignal]
    added: typing.ClassVar[QtCore.pyqtSignal]
    def componentComplete(self) -> None: ...
    def setLabelsPosition(self, position: 'QPieSlice.LabelPosition') -> None: ...
    def setLabelsVisible(self, visible: bool) -> None: ...
    def holeSize(self) -> float: ...
    def setHoleSize(self, holeSize: float) -> None: ...
    def endAngle(self) -> float: ...
    def setEndAngle(self, endAngle: float) -> None: ...
    def startAngle(self) -> float: ...
    def setStartAngle(self, startAngle: float) -> None: ...
    def pieSize(self) -> float: ...
    def setPieSize(self, relativeSize: float) -> None: ...
    def verticalPosition(self) -> float: ...
    def setVerticalPosition(self, relativePosition: float) -> None: ...
    def horizontalPosition(self) -> float: ...
    def setHorizontalPosition(self, relativePosition: float) -> None: ...
    def sum(self) -> float: ...
    def isEmpty(self) -> bool: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def slices(self) -> list['QPieSlice']: ...
    def __lshift__(self, slice: 'QPieSlice|None') -> 'QPieSeries': ...
    def take(self, slice: 'QPieSlice|None') -> bool: ...
    @typing.overload
    def replace(self, index: int, slice: 'QPieSlice|None') -> bool: ...
    @typing.overload
    def replace(self, oldSlice: 'QPieSlice|None', newSlice: 'QPieSlice|None') -> bool: ...
    @typing.overload
    def replace(self, slices: collections.abc.Iterable['QPieSlice']) -> bool: ...
    def removeMultiple(self, index: int, count: int) -> None: ...
    def find(self, label: str|None) -> 'QPieSlice|None': ...
    def at(self, index: int) -> 'QPieSlice|None': ...
    def clear(self) -> None: ...
    @typing.overload
    def remove(self, slice: 'QPieSlice|None') -> bool: ...
    @typing.overload
    def remove(self, index: int) -> bool: ...
    def insert(self, index: int, slice: 'QPieSlice|None') -> bool: ...
    @typing.overload
    def append(self, slice: 'QPieSlice|None') -> bool: ...
    @typing.overload
    def append(self, slices: collections.abc.Iterable['QPieSlice']) -> bool: ...
    @typing.overload
    def append(self, label: str|None, value: float) -> 'QPieSlice|None': ...
    def type(self) -> QAbstractSeries.SeriesType: ...


class QPieSlice(QtCore.QObject):

    class LabelPosition(enum.Enum):
        Outside = ... # type: QPieSlice.LabelPosition
        InsideHorizontal = ... # type: QPieSlice.LabelPosition
        InsideTangential = ... # type: QPieSlice.LabelPosition
        InsideNormal = ... # type: QPieSlice.LabelPosition

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, label: str|None, value: float, parent: QtCore.QObject|None = ...) -> None: ...

    borderWidthChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelArmLengthFactorChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    angleSpanChanged: typing.ClassVar[QtCore.pyqtSignal]
    startAngleChanged: typing.ClassVar[QtCore.pyqtSignal]
    percentageChanged: typing.ClassVar[QtCore.pyqtSignal]
    explodeDistanceFactorChanged: typing.ClassVar[QtCore.pyqtSignal]
    explodedChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelFontChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def series(self) -> QPieSeries|None: ...
    def angleSpan(self) -> float: ...
    def startAngle(self) -> float: ...
    def percentage(self) -> float: ...
    def explodeDistanceFactor(self) -> float: ...
    def setExplodeDistanceFactor(self, factor: float) -> None: ...
    def isExploded(self) -> bool: ...
    def setExploded(self, exploded: bool) -> None: ...
    def value(self) -> float: ...
    def setValue(self, value: float) -> None: ...
    def borderWidth(self) -> float: ...
    def setBorderWidth(self, borderWidth: float) -> None: ...
    def borderColor(self) -> QtGui.QColor: ...
    def setBorderColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def labelArmLengthFactor(self) -> float: ...
    def setLabelArmLengthFactor(self, factor: float) -> None: ...
    def labelFont(self) -> QtGui.QFont: ...
    def setLabelFont(self, font: QtGui.QFont) -> None: ...
    def labelColor(self) -> QtGui.QColor: ...
    def setLabelColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def labelPosition(self) -> 'QPieSlice.LabelPosition': ...
    def setLabelPosition(self, position: 'QPieSlice.LabelPosition') -> None: ...
    def isLabelVisible(self) -> bool: ...
    def setLabelVisible(self, visible: bool = ...) -> None: ...
    def label(self) -> str: ...
    def setLabel(self, label: str|None) -> None: ...


class QScatter3DSeries(QAbstract3DSeries):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, dataProxy: QScatterDataProxy|None, parent: QtCore.QObject|None = ...) -> None: ...

    scaleArrayChanged: typing.ClassVar[QtCore.pyqtSignal]
    def scaleArray(self) -> list[QtGui.QVector3D]: ...
    def clearScaleArray(self) -> None: ...
    def setScaleArray(self, newScaleArray: collections.abc.Iterable[QtGui.QVector3D]) -> None: ...
    dataArrayChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemSizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedItemChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataProxyChanged: typing.ClassVar[QtCore.pyqtSignal]
    def dataArray(self) -> list['QScatterDataItem']: ...
    def clearArray(self) -> None: ...
    def setDataArray(self, newDataArray: collections.abc.Iterable['QScatterDataItem']) -> None: ...
    def itemSize(self) -> float: ...
    def setItemSize(self, size: float) -> None: ...
    @staticmethod
    def invalidSelectionIndex() -> int: ...
    def selectedItem(self) -> int: ...
    def setSelectedItem(self, index: int) -> None: ...
    def dataProxy(self) -> QScatterDataProxy|None: ...
    def setDataProxy(self, proxy: QScatterDataProxy|None) -> None: ...


class QScatterDataItem(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, position: QtGui.QVector3D) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, z: float) -> None: ...
    @typing.overload
    def __init__(self, position: QtGui.QVector3D, rotation: QtGui.QQuaternion) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QScatterDataItem') -> None: ...

    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def setZ(self, value: float) -> None: ...
    def setY(self, value: float) -> None: ...
    def setX(self, value: float) -> None: ...
    def rotation(self) -> QtGui.QQuaternion: ...
    def setRotation(self, rot: QtGui.QQuaternion) -> None: ...
    def position(self) -> QtGui.QVector3D: ...
    def setPosition(self, pos: QtGui.QVector3D) -> None: ...


class QScatterSeries(QXYSeries):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def componentComplete(self) -> None: ...
    def type(self) -> QAbstractSeries.SeriesType: ...


class QSplineSeries(QXYSeries):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def componentComplete(self) -> None: ...
    capStyleChanged: typing.ClassVar[QtCore.pyqtSignal]
    widthChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setCapStyle(self, newCapStyle: QtCore.Qt.PenCapStyle) -> None: ...
    def capStyle(self) -> QtCore.Qt.PenCapStyle: ...
    def setWidth(self, newWidth: float) -> None: ...
    def width(self) -> float: ...
    def type(self) -> QAbstractSeries.SeriesType: ...


class QSpline3DSeries(QScatter3DSeries):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, dataProxy: QScatterDataProxy|None, parent: QtCore.QObject|None = ...) -> None: ...

    splineResolutionChanged: typing.ClassVar[QtCore.pyqtSignal]
    splineColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    splineLoopingChanged: typing.ClassVar[QtCore.pyqtSignal]
    splineKnottingChanged: typing.ClassVar[QtCore.pyqtSignal]
    splineTensionChanged: typing.ClassVar[QtCore.pyqtSignal]
    splineVisibilityChanged: typing.ClassVar[QtCore.pyqtSignal]
    def splineResolution(self) -> int: ...
    def setSplineResolution(self, resolution: int) -> None: ...
    def splineColor(self) -> QtGui.QColor: ...
    def setSplineColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def isSplineLooping(self) -> bool: ...
    def setSplineLooping(self, looping: bool) -> None: ...
    def splineKnotting(self) -> float: ...
    def setSplineKnotting(self, knotting: float) -> None: ...
    def splineTension(self) -> float: ...
    def setSplineTension(self, tension: float) -> None: ...
    def isSplineVisible(self) -> bool: ...
    def setSplineVisible(self, draw: bool) -> None: ...


class QSurface3DSeries(QAbstract3DSeries):

    class Shading(enum.Enum):
        Smooth = ... # type: QSurface3DSeries.Shading
        Flat = ... # type: QSurface3DSeries.Shading

    class DrawFlag(enum.Flag):
        DrawWireframe = ... # type: QSurface3DSeries.DrawFlag
        DrawSurface = ... # type: QSurface3DSeries.DrawFlag
        DrawSurfaceAndWireframe = ... # type: QSurface3DSeries.DrawFlag
        DrawFilledSurface = ... # type: QSurface3DSeries.DrawFlag

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, dataProxy: QSurfaceDataProxy|None, parent: QtCore.QObject|None = ...) -> None: ...

    shadingChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataArrayChanged: typing.ClassVar[QtCore.pyqtSignal]
    wireframeColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureFileChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureChanged: typing.ClassVar[QtCore.pyqtSignal]
    drawModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    flatShadingSupportedChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedPointChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataProxyChanged: typing.ClassVar[QtCore.pyqtSignal]
    def dataArray(self) -> list[list['QSurfaceDataItem']]: ...
    def clearArray(self) -> None: ...
    def clearRow(self, rowIndex: int) -> None: ...
    def setDataArray(self, newDataArray: collections.abc.Iterable[collections.abc.Iterable['QSurfaceDataItem']]) -> None: ...
    def wireframeColor(self) -> QtGui.QColor: ...
    def setWireframeColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def textureFile(self) -> str: ...
    def setTextureFile(self, filename: str|None) -> None: ...
    def texture(self) -> QtGui.QImage: ...
    def setTexture(self, texture: QtGui.QImage) -> None: ...
    def isFlatShadingSupported(self) -> bool: ...
    def drawMode(self) -> 'QSurface3DSeries.DrawFlag': ...
    def setDrawMode(self, mode: 'QSurface3DSeries.DrawFlag') -> None: ...
    def shading(self) -> 'QSurface3DSeries.Shading': ...
    def setShading(self, shading: 'QSurface3DSeries.Shading') -> None: ...
    @staticmethod
    def invalidSelectionPosition() -> QtCore.QPoint: ...
    def selectedPoint(self) -> QtCore.QPoint: ...
    def setSelectedPoint(self, position: QtCore.QPoint) -> None: ...
    def dataProxy(self) -> QSurfaceDataProxy|None: ...
    def setDataProxy(self, proxy: QSurfaceDataProxy|None) -> None: ...


class QSurfaceDataItem(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, position: QtGui.QVector3D) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, z: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QSurfaceDataItem') -> None: ...

    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def setZ(self, value: float) -> None: ...
    def setY(self, value: float) -> None: ...
    def setX(self, value: float) -> None: ...
    def position(self) -> QtGui.QVector3D: ...
    def setPosition(self, pos: QtGui.QVector3D) -> None: ...


class QValue3DAxis(QAbstract3DAxis):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    reversedChanged: typing.ClassVar[QtCore.pyqtSignal]
    formatterChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    subSegmentCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    segmentCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    def reversed(self) -> bool: ...
    def setReversed(self, enable: bool) -> None: ...
    def formatter(self) -> QValue3DAxisFormatter|None: ...
    def setFormatter(self, formatter: QValue3DAxisFormatter|None) -> None: ...
    def labelFormat(self) -> str: ...
    def setLabelFormat(self, format: str|None) -> None: ...
    def subSegmentCount(self) -> int: ...
    def setSubSegmentCount(self, count: int) -> None: ...
    def segmentCount(self) -> int: ...
    def setSegmentCount(self, count: int) -> None: ...


class QValueAxis(QAbstractAxis):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    panChanged: typing.ClassVar[QtCore.pyqtSignal]
    zoomChanged: typing.ClassVar[QtCore.pyqtSignal]
    def pan(self) -> float: ...
    def setPan(self, pan: float) -> None: ...
    def zoom(self) -> float: ...
    def setZoom(self, zoom: float) -> None: ...
    tickIntervalChanged: typing.ClassVar[QtCore.pyqtSignal]
    tickAnchorChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelDecimalsChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    subTickCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxChanged: typing.ClassVar[QtCore.pyqtSignal]
    minChanged: typing.ClassVar[QtCore.pyqtSignal]
    def labelDecimals(self) -> int: ...
    def setLabelDecimals(self, decimals: int) -> None: ...
    def labelFormat(self) -> str: ...
    def setLabelFormat(self, format: str|None) -> None: ...
    def tickInterval(self) -> float: ...
    def setTickInterval(self, interval: float) -> None: ...
    def tickAnchor(self) -> float: ...
    def setTickAnchor(self, anchor: float) -> None: ...
    def subTickCount(self) -> int: ...
    def setSubTickCount(self, count: int) -> None: ...
    def setRange(self, min: float, max: float) -> None: ...
    def max(self) -> float: ...
    def setMax(self, max: float) -> None: ...
    def min(self) -> float: ...
    def setMin(self, min: float) -> None: ...
    def type(self) -> QAbstractAxis.AxisType: ...


class QXYModelMapper(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    orientationChanged: typing.ClassVar[QtCore.pyqtSignal]
    countChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstChanged: typing.ClassVar[QtCore.pyqtSignal]
    ySectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    xSectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    modelChanged: typing.ClassVar[QtCore.pyqtSignal]
    seriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setYSection(self, ySection: int) -> None: ...
    def ySection(self) -> int: ...
    def setXSection(self, xSection: int) -> None: ...
    def xSection(self) -> int: ...
    def setOrientation(self, orientation: QtCore.Qt.Orientation) -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setCount(self, count: int) -> None: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def setFirst(self, first: int) -> None: ...
    def first(self) -> int: ...
    def setSeries(self, series: QXYSeries|None) -> None: ...
    def series(self) -> QXYSeries|None: ...
    def setModel(self, model: QtCore.QAbstractItemModel|None) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel|None: ...


PYQT_GRAPHS_VERSION = ... # type: int
PYQT_GRAPHS_VERSION_STR = ... # type: str


def qDefaultSurfaceFormat(antialias: bool) -> QtGui.QSurfaceFormat: ...
